/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.MLTransform;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class MLTransformMarshaller {
    private static final MarshallingInfo<String> TRANSFORMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransformId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Date> CREATEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> INPUTRECORDTABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputRecordTables").build();
    private static final MarshallingInfo<StructuredPojo> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<StructuredPojo> EVALUATIONMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationMetrics").build();
    private static final MarshallingInfo<Integer> LABELCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LabelCount").build();
    private static final MarshallingInfo<List> SCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Schema").build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Role").build();
    private static final MarshallingInfo<String> GLUEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlueVersion").build();
    private static final MarshallingInfo<Double> MAXCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxCapacity").build();
    private static final MarshallingInfo<String> WORKERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkerType").build();
    private static final MarshallingInfo<Integer> NUMBEROFWORKERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfWorkers").build();
    private static final MarshallingInfo<Integer> TIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timeout").build();
    private static final MarshallingInfo<Integer> MAXRETRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxRetries").build();
    private static final MLTransformMarshaller instance = new MLTransformMarshaller();

    public static MLTransformMarshaller getInstance() {
        return instance;
    }

    public void marshall(MLTransform mLTransform, ProtocolMarshaller protocolMarshaller) {
        if (mLTransform == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mLTransform.getTransformId(), TRANSFORMID_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getCreatedOn(), CREATEDON_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getLastModifiedOn(), LASTMODIFIEDON_BINDING);
            protocolMarshaller.marshall(mLTransform.getInputRecordTables(), INPUTRECORDTABLES_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getEvaluationMetrics(), EVALUATIONMETRICS_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getLabelCount(), LABELCOUNT_BINDING);
            protocolMarshaller.marshall(mLTransform.getSchema(), SCHEMA_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getRole(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getGlueVersion(), GLUEVERSION_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getMaxCapacity(), MAXCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getWorkerType(), WORKERTYPE_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getNumberOfWorkers(), NUMBEROFWORKERS_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getTimeout(), TIMEOUT_BINDING);
            protocolMarshaller.marshall((Object)mLTransform.getMaxRetries(), MAXRETRIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

