/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.globalaccelerator.model.Attachment;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AttachmentMarshaller {
    private static final MarshallingInfo<String> ATTACHMENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttachmentArn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> PRINCIPALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Principals").build();
    private static final MarshallingInfo<List> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").timestampFormat("unixTimestamp").build();
    private static final AttachmentMarshaller instance = new AttachmentMarshaller();

    public static AttachmentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Attachment attachment, ProtocolMarshaller protocolMarshaller) {
        if (attachment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)attachment.getAttachmentArn(), ATTACHMENTARN_BINDING);
            protocolMarshaller.marshall((Object)attachment.getName(), NAME_BINDING);
            protocolMarshaller.marshall(attachment.getPrincipals(), PRINCIPALS_BINDING);
            protocolMarshaller.marshall(attachment.getResources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)attachment.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall((Object)attachment.getCreatedTime(), CREATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

