/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.globalaccelerator.model.IpSet;
import java.util.List;

@SdkInternalApi
public class IpSetMarshaller {
    private static final MarshallingInfo<String> IPFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpFamily").build();
    private static final MarshallingInfo<List> IPADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddresses").build();
    private static final IpSetMarshaller instance = new IpSetMarshaller();

    public static IpSetMarshaller getInstance() {
        return instance;
    }

    public void marshall(IpSet ipSet, ProtocolMarshaller protocolMarshaller) {
        if (ipSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ipSet.getIpFamily(), IPFAMILY_BINDING);
            protocolMarshaller.marshall(ipSet.getIpAddresses(), IPADDRESSES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

