/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glacier.model.Grantee;
import com.amazonaws.services.glacier.model.Permission;
import com.amazonaws.services.glacier.model.transform.GrantMarshaller;
import java.io.Serializable;

public class Grant
implements Serializable,
Cloneable,
StructuredPojo {
    private Grantee grantee;
    private String permission;

    public void setGrantee(Grantee grantee) {
        this.grantee = grantee;
    }

    public Grantee getGrantee() {
        return this.grantee;
    }

    public Grant withGrantee(Grantee grantee) {
        this.setGrantee(grantee);
        return this;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getPermission() {
        return this.permission;
    }

    public Grant withPermission(String permission) {
        this.setPermission(permission);
        return this;
    }

    public Grant withPermission(Permission permission) {
        this.permission = permission.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGrantee() != null) {
            sb.append("Grantee: ").append(this.getGrantee()).append(",");
        }
        if (this.getPermission() != null) {
            sb.append("Permission: ").append(this.getPermission());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grant)) {
            return false;
        }
        Grant other = (Grant)obj;
        if (other.getGrantee() == null ^ this.getGrantee() == null) {
            return false;
        }
        if (other.getGrantee() != null && !other.getGrantee().equals(this.getGrantee())) {
            return false;
        }
        if (other.getPermission() == null ^ this.getPermission() == null) {
            return false;
        }
        return other.getPermission() == null || other.getPermission().equals(this.getPermission());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGrantee() == null ? 0 : this.getGrantee().hashCode());
        hashCode = 31 * hashCode + (this.getPermission() == null ? 0 : this.getPermission().hashCode());
        return hashCode;
    }

    public Grant clone() {
        try {
            return (Grant)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GrantMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

