/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.transfer;

import com.amazonaws.services.glacier.AmazonGlacier;
import com.amazonaws.services.glacier.AmazonGlacierClientBuilder;
import com.amazonaws.services.glacier.transfer.ArchiveTransferManager;
import com.amazonaws.services.glacier.transfer.ArchiveTransferManagerParams;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;

public final class ArchiveTransferManagerBuilder {
    private AmazonGlacier glacierClient;
    private AmazonSQS sqsClient;
    private AmazonSNS snsClient;

    public AmazonGlacier getGlacierClient() {
        return this.glacierClient;
    }

    public void setGlacierClient(AmazonGlacier glacierClient) {
        this.glacierClient = glacierClient;
    }

    public ArchiveTransferManagerBuilder withGlacierClient(AmazonGlacier glacierClient) {
        this.setGlacierClient(glacierClient);
        return this;
    }

    public AmazonSQS getSqsClient() {
        return this.sqsClient;
    }

    public void setSqsClient(AmazonSQS sqsClient) {
        this.sqsClient = sqsClient;
    }

    public ArchiveTransferManagerBuilder withSqsClient(AmazonSQS sqsClient) {
        this.setSqsClient(sqsClient);
        return this;
    }

    public AmazonSNS getSnsClient() {
        return this.snsClient;
    }

    public void setSnsClient(AmazonSNS snsClient) {
        this.snsClient = snsClient;
    }

    public ArchiveTransferManagerBuilder withSnsClient(AmazonSNS snsClient) {
        this.setSnsClient(snsClient);
        return this;
    }

    private AmazonGlacier resolveGlacierClient() {
        return this.glacierClient == null ? AmazonGlacierClientBuilder.defaultClient() : this.glacierClient;
    }

    private AmazonSNS resolveSNSClient() {
        return this.snsClient == null ? AmazonSNSClientBuilder.defaultClient() : this.snsClient;
    }

    private AmazonSQS resolveSQSClient() {
        return this.sqsClient == null ? AmazonSQSClientBuilder.defaultClient() : this.sqsClient;
    }

    private ArchiveTransferManagerParams getParams() {
        return new ArchiveTransferManagerParams().withAmazonGlacier(this.resolveGlacierClient()).withAmazonSQS(this.resolveSQSClient()).withAmazonSNS(this.resolveSNSClient());
    }

    public ArchiveTransferManager build() {
        return new ArchiveTransferManager(this.getParams());
    }
}

