/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetJobOutputRequestMarshaller
implements Marshaller<Request<GetJobOutputRequest>, GetJobOutputRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetJobOutputRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetJobOutputRequest> marshall(GetJobOutputRequest getJobOutputRequest) {
        if (getJobOutputRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getJobOutputRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        if (getJobOutputRequest.getRange() != null) {
            request.addHeader("Range", StringUtils.fromString((String)getJobOutputRequest.getRange()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs/{jobId}/output";
        uriResourcePath = uriResourcePath.replace("{accountId}", getJobOutputRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getJobOutputRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", getJobOutputRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getJobOutputRequest.getVaultName()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{jobId}", getJobOutputRequest.getJobId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getJobOutputRequest.getJobId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

