/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.AmazonGlacier;
import com.amazonaws.services.glacier.model.AbortMultipartUploadRequest;
import com.amazonaws.services.glacier.model.AbortMultipartUploadResult;
import com.amazonaws.services.glacier.model.AbortVaultLockRequest;
import com.amazonaws.services.glacier.model.AbortVaultLockResult;
import com.amazonaws.services.glacier.model.AddTagsToVaultRequest;
import com.amazonaws.services.glacier.model.AddTagsToVaultResult;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadResult;
import com.amazonaws.services.glacier.model.CompleteVaultLockRequest;
import com.amazonaws.services.glacier.model.CompleteVaultLockResult;
import com.amazonaws.services.glacier.model.CreateVaultRequest;
import com.amazonaws.services.glacier.model.CreateVaultResult;
import com.amazonaws.services.glacier.model.DeleteArchiveRequest;
import com.amazonaws.services.glacier.model.DeleteArchiveResult;
import com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyRequest;
import com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyResult;
import com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.DeleteVaultNotificationsResult;
import com.amazonaws.services.glacier.model.DeleteVaultRequest;
import com.amazonaws.services.glacier.model.DeleteVaultResult;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.services.glacier.model.DescribeJobResult;
import com.amazonaws.services.glacier.model.DescribeVaultRequest;
import com.amazonaws.services.glacier.model.DescribeVaultResult;
import com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest;
import com.amazonaws.services.glacier.model.GetDataRetrievalPolicyResult;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.GetJobOutputResult;
import com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest;
import com.amazonaws.services.glacier.model.GetVaultAccessPolicyResult;
import com.amazonaws.services.glacier.model.GetVaultLockRequest;
import com.amazonaws.services.glacier.model.GetVaultLockResult;
import com.amazonaws.services.glacier.model.GetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.GetVaultNotificationsResult;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InitiateJobResult;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadResult;
import com.amazonaws.services.glacier.model.InitiateVaultLockRequest;
import com.amazonaws.services.glacier.model.InitiateVaultLockResult;
import com.amazonaws.services.glacier.model.InvalidParameterValueException;
import com.amazonaws.services.glacier.model.LimitExceededException;
import com.amazonaws.services.glacier.model.ListJobsRequest;
import com.amazonaws.services.glacier.model.ListJobsResult;
import com.amazonaws.services.glacier.model.ListMultipartUploadsRequest;
import com.amazonaws.services.glacier.model.ListMultipartUploadsResult;
import com.amazonaws.services.glacier.model.ListPartsRequest;
import com.amazonaws.services.glacier.model.ListPartsResult;
import com.amazonaws.services.glacier.model.ListTagsForVaultRequest;
import com.amazonaws.services.glacier.model.ListTagsForVaultResult;
import com.amazonaws.services.glacier.model.ListVaultsRequest;
import com.amazonaws.services.glacier.model.ListVaultsResult;
import com.amazonaws.services.glacier.model.MissingParameterValueException;
import com.amazonaws.services.glacier.model.PolicyEnforcedException;
import com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest;
import com.amazonaws.services.glacier.model.RemoveTagsFromVaultResult;
import com.amazonaws.services.glacier.model.RequestTimeoutException;
import com.amazonaws.services.glacier.model.ResourceNotFoundException;
import com.amazonaws.services.glacier.model.ServiceUnavailableException;
import com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest;
import com.amazonaws.services.glacier.model.SetDataRetrievalPolicyResult;
import com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest;
import com.amazonaws.services.glacier.model.SetVaultAccessPolicyResult;
import com.amazonaws.services.glacier.model.SetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.SetVaultNotificationsResult;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.services.glacier.model.UploadArchiveResult;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.services.glacier.model.UploadMultipartPartResult;
import com.amazonaws.services.glacier.model.transform.AbortMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.AbortMultipartUploadResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.AbortVaultLockRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.AbortVaultLockResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.AddTagsToVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.AddTagsToVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.CompleteMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CompleteMultipartUploadResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.CompleteVaultLockRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CompleteVaultLockResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.CreateVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CreateVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteArchiveRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteArchiveResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultAccessPolicyRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultAccessPolicyResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeJobRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeJobResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetDataRetrievalPolicyRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetDataRetrievalPolicyResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetJobOutputRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetJobOutputResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultAccessPolicyRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultAccessPolicyResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultLockRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultLockResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateJobRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateJobResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateMultipartUploadResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateVaultLockRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateVaultLockResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListJobsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListMultipartUploadsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListMultipartUploadsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListPartsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListPartsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListTagsForVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListTagsForVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListVaultsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListVaultsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.RemoveTagsFromVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.RemoveTagsFromVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.SetDataRetrievalPolicyRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.SetDataRetrievalPolicyResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.SetVaultAccessPolicyRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.SetVaultAccessPolicyResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.SetVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.SetVaultNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.UploadArchiveRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.UploadArchiveResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.UploadMultipartPartRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.UploadMultipartPartResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.LengthCheckInputStream;
import com.amazonaws.util.ServiceClientHolderInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonGlacierClient
extends AmazonWebServiceClient
implements AmazonGlacier {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonGlacier.class);
    private static final String DEFAULT_SIGNING_NAME = "glacier";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(InvalidParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestTimeoutException").withModeledClass(RequestTimeoutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyEnforcedException").withModeledClass(PolicyEnforcedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingParameterValueException").withModeledClass(MissingParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)));

    public AmazonGlacierClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AmazonGlacierClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonGlacierClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonGlacierClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonGlacierClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonGlacierClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonGlacierClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://glacier.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/glacier/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/glacier/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbortMultipartUploadResult abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(abortMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AbortMultipartUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AbortMultipartUploadRequestMarshaller(this.protocolFactory).marshall((AbortMultipartUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)abortMultipartUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AbortMultipartUploadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AbortMultipartUploadResult abortMultipartUploadResult = (AbortMultipartUploadResult)response.getAwsResponse();
            return abortMultipartUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbortVaultLockResult abortVaultLock(AbortVaultLockRequest abortVaultLockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(abortVaultLockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AbortVaultLockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AbortVaultLockRequestMarshaller(this.protocolFactory).marshall((AbortVaultLockRequest)super.beforeMarshalling((AmazonWebServiceRequest)abortVaultLockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AbortVaultLockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AbortVaultLockResult abortVaultLockResult = (AbortVaultLockResult)response.getAwsResponse();
            return abortVaultLockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsToVaultResult addTagsToVault(AddTagsToVaultRequest addTagsToVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsToVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsToVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsToVaultRequestMarshaller(this.protocolFactory).marshall((AddTagsToVaultRequest)super.beforeMarshalling((AmazonWebServiceRequest)addTagsToVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsToVaultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddTagsToVaultResult addTagsToVaultResult = (AddTagsToVaultResult)response.getAwsResponse();
            return addTagsToVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(completeMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CompleteMultipartUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CompleteMultipartUploadRequestMarshaller(this.protocolFactory).marshall((CompleteMultipartUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)completeMultipartUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CompleteMultipartUploadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CompleteMultipartUploadResult completeMultipartUploadResult = (CompleteMultipartUploadResult)response.getAwsResponse();
            return completeMultipartUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompleteVaultLockResult completeVaultLock(CompleteVaultLockRequest completeVaultLockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(completeVaultLockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CompleteVaultLockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CompleteVaultLockRequestMarshaller(this.protocolFactory).marshall((CompleteVaultLockRequest)super.beforeMarshalling((AmazonWebServiceRequest)completeVaultLockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CompleteVaultLockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CompleteVaultLockResult completeVaultLockResult = (CompleteVaultLockResult)response.getAwsResponse();
            return completeVaultLockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVaultResult createVault(CreateVaultRequest createVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateVaultRequestMarshaller(this.protocolFactory).marshall((CreateVaultRequest)super.beforeMarshalling((AmazonWebServiceRequest)createVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateVaultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateVaultResult createVaultResult = (CreateVaultResult)response.getAwsResponse();
            return createVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteArchiveResult deleteArchive(DeleteArchiveRequest deleteArchiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteArchiveRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteArchiveRequestMarshaller(this.protocolFactory).marshall((DeleteArchiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteArchiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteArchiveResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteArchiveResult deleteArchiveResult = (DeleteArchiveResult)response.getAwsResponse();
            return deleteArchiveResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVaultResult deleteVault(DeleteVaultRequest deleteVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVaultRequestMarshaller(this.protocolFactory).marshall((DeleteVaultRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVaultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteVaultResult deleteVaultResult = (DeleteVaultResult)response.getAwsResponse();
            return deleteVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVaultAccessPolicyResult deleteVaultAccessPolicy(DeleteVaultAccessPolicyRequest deleteVaultAccessPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVaultAccessPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVaultAccessPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVaultAccessPolicyRequestMarshaller(this.protocolFactory).marshall((DeleteVaultAccessPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteVaultAccessPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVaultAccessPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteVaultAccessPolicyResult deleteVaultAccessPolicyResult = (DeleteVaultAccessPolicyResult)response.getAwsResponse();
            return deleteVaultAccessPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVaultNotificationsResult deleteVaultNotifications(DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVaultNotificationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVaultNotificationsRequestMarshaller(this.protocolFactory).marshall((DeleteVaultNotificationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteVaultNotificationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVaultNotificationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteVaultNotificationsResult deleteVaultNotificationsResult = (DeleteVaultNotificationsResult)response.getAwsResponse();
            return deleteVaultNotificationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobResult describeJob(DescribeJobRequest describeJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobRequestMarshaller(this.protocolFactory).marshall((DescribeJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeJobResult describeJobResult = (DescribeJobResult)response.getAwsResponse();
            return describeJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVaultResult describeVault(DescribeVaultRequest describeVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVaultRequestMarshaller(this.protocolFactory).marshall((DescribeVaultRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeVaultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeVaultResult describeVaultResult = (DescribeVaultResult)response.getAwsResponse();
            return describeVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataRetrievalPolicyResult getDataRetrievalPolicy(GetDataRetrievalPolicyRequest getDataRetrievalPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataRetrievalPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataRetrievalPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataRetrievalPolicyRequestMarshaller(this.protocolFactory).marshall((GetDataRetrievalPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataRetrievalPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataRetrievalPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataRetrievalPolicyResult getDataRetrievalPolicyResult = (GetDataRetrievalPolicyResult)response.getAwsResponse();
            return getDataRetrievalPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobOutputResult getJobOutput(GetJobOutputRequest getJobOutputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobOutputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobOutputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobOutputRequestMarshaller(this.protocolFactory).marshall((GetJobOutputRequest)super.beforeMarshalling((AmazonWebServiceRequest)getJobOutputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new GetJobOutputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetJobOutputResult result = (GetJobOutputResult)response.getAwsResponse();
            result.setBody((InputStream)new LengthCheckInputStream(result.getBody(), Long.parseLong((String)response.getHttpResponse().getHeaders().get("Content-Length")), true));
            result.setBody((InputStream)new ServiceClientHolderInputStream(result.getBody(), (AmazonWebServiceClient)this));
            GetJobOutputResult getJobOutputResult = (GetJobOutputResult)response.getAwsResponse();
            return getJobOutputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVaultAccessPolicyResult getVaultAccessPolicy(GetVaultAccessPolicyRequest getVaultAccessPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getVaultAccessPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetVaultAccessPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetVaultAccessPolicyRequestMarshaller(this.protocolFactory).marshall((GetVaultAccessPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getVaultAccessPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetVaultAccessPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetVaultAccessPolicyResult getVaultAccessPolicyResult = (GetVaultAccessPolicyResult)response.getAwsResponse();
            return getVaultAccessPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVaultLockResult getVaultLock(GetVaultLockRequest getVaultLockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getVaultLockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetVaultLockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetVaultLockRequestMarshaller(this.protocolFactory).marshall((GetVaultLockRequest)super.beforeMarshalling((AmazonWebServiceRequest)getVaultLockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetVaultLockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetVaultLockResult getVaultLockResult = (GetVaultLockResult)response.getAwsResponse();
            return getVaultLockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVaultNotificationsResult getVaultNotifications(GetVaultNotificationsRequest getVaultNotificationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetVaultNotificationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetVaultNotificationsRequestMarshaller(this.protocolFactory).marshall((GetVaultNotificationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getVaultNotificationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetVaultNotificationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetVaultNotificationsResult getVaultNotificationsResult = (GetVaultNotificationsResult)response.getAwsResponse();
            return getVaultNotificationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateJobResult initiateJob(InitiateJobRequest initiateJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initiateJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateJobRequestMarshaller(this.protocolFactory).marshall((InitiateJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)initiateJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitiateJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InitiateJobResult initiateJobResult = (InitiateJobResult)response.getAwsResponse();
            return initiateJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initiateMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateMultipartUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateMultipartUploadRequestMarshaller(this.protocolFactory).marshall((InitiateMultipartUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)initiateMultipartUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitiateMultipartUploadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InitiateMultipartUploadResult initiateMultipartUploadResult = (InitiateMultipartUploadResult)response.getAwsResponse();
            return initiateMultipartUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateVaultLockResult initiateVaultLock(InitiateVaultLockRequest initiateVaultLockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initiateVaultLockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateVaultLockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateVaultLockRequestMarshaller(this.protocolFactory).marshall((InitiateVaultLockRequest)super.beforeMarshalling((AmazonWebServiceRequest)initiateVaultLockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitiateVaultLockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InitiateVaultLockResult initiateVaultLockResult = (InitiateVaultLockResult)response.getAwsResponse();
            return initiateVaultLockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResult listJobs(ListJobsRequest listJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestMarshaller(this.protocolFactory).marshall((ListJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJobsResult listJobsResult = (ListJobsResult)response.getAwsResponse();
            return listJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultipartUploadsResult listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMultipartUploadsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMultipartUploadsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMultipartUploadsRequestMarshaller(this.protocolFactory).marshall((ListMultipartUploadsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMultipartUploadsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMultipartUploadsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMultipartUploadsResult listMultipartUploadsResult = (ListMultipartUploadsResult)response.getAwsResponse();
            return listMultipartUploadsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPartsResult listParts(ListPartsRequest listPartsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPartsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPartsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPartsRequestMarshaller(this.protocolFactory).marshall((ListPartsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPartsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPartsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPartsResult listPartsResult = (ListPartsResult)response.getAwsResponse();
            return listPartsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForVaultResult listTagsForVault(ListTagsForVaultRequest listTagsForVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForVaultRequestMarshaller(this.protocolFactory).marshall((ListTagsForVaultRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForVaultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForVaultResult listTagsForVaultResult = (ListTagsForVaultResult)response.getAwsResponse();
            return listTagsForVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVaultsResult listVaults(ListVaultsRequest listVaultsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listVaultsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListVaultsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListVaultsRequestMarshaller(this.protocolFactory).marshall((ListVaultsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listVaultsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListVaultsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListVaultsResult listVaultsResult = (ListVaultsResult)response.getAwsResponse();
            return listVaultsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsFromVaultResult removeTagsFromVault(RemoveTagsFromVaultRequest removeTagsFromVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTagsFromVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTagsFromVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTagsFromVaultRequestMarshaller(this.protocolFactory).marshall((RemoveTagsFromVaultRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeTagsFromVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTagsFromVaultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveTagsFromVaultResult removeTagsFromVaultResult = (RemoveTagsFromVaultResult)response.getAwsResponse();
            return removeTagsFromVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetDataRetrievalPolicyResult setDataRetrievalPolicy(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setDataRetrievalPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetDataRetrievalPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetDataRetrievalPolicyRequestMarshaller(this.protocolFactory).marshall((SetDataRetrievalPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)setDataRetrievalPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetDataRetrievalPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetDataRetrievalPolicyResult setDataRetrievalPolicyResult = (SetDataRetrievalPolicyResult)response.getAwsResponse();
            return setDataRetrievalPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetVaultAccessPolicyResult setVaultAccessPolicy(SetVaultAccessPolicyRequest setVaultAccessPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setVaultAccessPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetVaultAccessPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetVaultAccessPolicyRequestMarshaller(this.protocolFactory).marshall((SetVaultAccessPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)setVaultAccessPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetVaultAccessPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetVaultAccessPolicyResult setVaultAccessPolicyResult = (SetVaultAccessPolicyResult)response.getAwsResponse();
            return setVaultAccessPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetVaultNotificationsResult setVaultNotifications(SetVaultNotificationsRequest setVaultNotificationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetVaultNotificationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetVaultNotificationsRequestMarshaller(this.protocolFactory).marshall((SetVaultNotificationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)setVaultNotificationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetVaultNotificationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetVaultNotificationsResult setVaultNotificationsResult = (SetVaultNotificationsResult)response.getAwsResponse();
            return setVaultNotificationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadArchiveResult uploadArchive(UploadArchiveRequest uploadArchiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(uploadArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UploadArchiveRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UploadArchiveRequestMarshaller(this.protocolFactory).marshall((UploadArchiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)uploadArchiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UploadArchiveResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UploadArchiveResult uploadArchiveResult = (UploadArchiveResult)response.getAwsResponse();
            return uploadArchiveResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadMultipartPartResult uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest) {
        ExecutionContext executionContext = this.createExecutionContext(uploadMultipartPartRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UploadMultipartPartRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UploadMultipartPartRequestMarshaller(this.protocolFactory).marshall((UploadMultipartPartRequest)super.beforeMarshalling((AmazonWebServiceRequest)uploadMultipartPartRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UploadMultipartPartResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UploadMultipartPartResult uploadMultipartPartResult = (UploadMultipartPartResult)response.getAwsResponse();
            return uploadMultipartPartResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata().withCustomErrorCodeFieldName("code"));
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

