/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RemoveTagsFromVaultRequestMarshaller
implements Marshaller<Request<RemoveTagsFromVaultRequest>, RemoveTagsFromVaultRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<RemoveTagsFromVaultRequest> marshall(RemoveTagsFromVaultRequest removeTagsFromVaultRequest) {
        Object name;
        if (removeTagsFromVaultRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeTagsFromVaultRequest, "AmazonGlacier");
        String target = "Glacier.RemoveTagsFromVault";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("accountId")) {
            String string;
            name = DYNAMIC_QUERY_PARAMS.get("accountId");
            String string2 = string = removeTagsFromVaultRequest.getAccountId() == null ? null : StringUtils.fromString((String)removeTagsFromVaultRequest.getAccountId());
            if (string != null && !string.isEmpty()) {
                request.addParameter((String)name, string);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{accountId}", removeTagsFromVaultRequest.getAccountId() == null ? "" : StringUtils.fromString((String)removeTagsFromVaultRequest.getAccountId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("vaultName")) {
            String string;
            name = DYNAMIC_QUERY_PARAMS.get("vaultName");
            String string3 = string = removeTagsFromVaultRequest.getVaultName() == null ? null : StringUtils.fromString((String)removeTagsFromVaultRequest.getVaultName());
            if (string != null && !string.isEmpty()) {
                request.addParameter((String)name, string);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{vaultName}", removeTagsFromVaultRequest.getVaultName() == null ? "" : StringUtils.fromString((String)removeTagsFromVaultRequest.getVaultName()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jSONWriter = new JSONWriter((Writer)stringWriter);
            jSONWriter.object();
            ListWithAutoConstructFlag tagKeysList = (ListWithAutoConstructFlag)removeTagsFromVaultRequest.getTagKeys();
            if (!(tagKeysList == null || tagKeysList.isAutoConstruct() && tagKeysList.isEmpty())) {
                jSONWriter.key("TagKeys");
                jSONWriter.array();
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue == null) continue;
                    jSONWriter.value((Object)tagKeysListValue);
                }
                jSONWriter.endArray();
            }
            jSONWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    static {
        String path = "/{accountId}/vaults/{vaultName}/tags?operation=remove";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

