/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gamesparks;

import javax.annotation.Generated;

import com.amazonaws.services.gamesparks.model.*;

/**
 * Abstract implementation of {@code AWSGameSparksAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSGameSparksAsync extends AbstractAWSGameSparks implements AWSGameSparksAsync {

    protected AbstractAWSGameSparksAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateGameResult> createGameAsync(CreateGameRequest request) {

        return createGameAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateGameResult> createGameAsync(CreateGameRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateGameRequest, CreateGameResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request) {

        return createSnapshotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSnapshotRequest, CreateSnapshotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateStageResult> createStageAsync(CreateStageRequest request) {

        return createStageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateStageResult> createStageAsync(CreateStageRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateStageRequest, CreateStageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteGameResult> deleteGameAsync(DeleteGameRequest request) {

        return deleteGameAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteGameResult> deleteGameAsync(DeleteGameRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteGameRequest, DeleteGameResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteStageResult> deleteStageAsync(DeleteStageRequest request) {

        return deleteStageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteStageResult> deleteStageAsync(DeleteStageRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteStageRequest, DeleteStageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisconnectPlayerResult> disconnectPlayerAsync(DisconnectPlayerRequest request) {

        return disconnectPlayerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisconnectPlayerResult> disconnectPlayerAsync(DisconnectPlayerRequest request,
            com.amazonaws.handlers.AsyncHandler<DisconnectPlayerRequest, DisconnectPlayerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ExportSnapshotResult> exportSnapshotAsync(ExportSnapshotRequest request) {

        return exportSnapshotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ExportSnapshotResult> exportSnapshotAsync(ExportSnapshotRequest request,
            com.amazonaws.handlers.AsyncHandler<ExportSnapshotRequest, ExportSnapshotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetExtensionResult> getExtensionAsync(GetExtensionRequest request) {

        return getExtensionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetExtensionResult> getExtensionAsync(GetExtensionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetExtensionRequest, GetExtensionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetExtensionVersionResult> getExtensionVersionAsync(GetExtensionVersionRequest request) {

        return getExtensionVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetExtensionVersionResult> getExtensionVersionAsync(GetExtensionVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetExtensionVersionRequest, GetExtensionVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGameResult> getGameAsync(GetGameRequest request) {

        return getGameAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGameResult> getGameAsync(GetGameRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGameRequest, GetGameResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGameConfigurationResult> getGameConfigurationAsync(GetGameConfigurationRequest request) {

        return getGameConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGameConfigurationResult> getGameConfigurationAsync(GetGameConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGameConfigurationRequest, GetGameConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGeneratedCodeJobResult> getGeneratedCodeJobAsync(GetGeneratedCodeJobRequest request) {

        return getGeneratedCodeJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGeneratedCodeJobResult> getGeneratedCodeJobAsync(GetGeneratedCodeJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGeneratedCodeJobRequest, GetGeneratedCodeJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPlayerConnectionStatusResult> getPlayerConnectionStatusAsync(GetPlayerConnectionStatusRequest request) {

        return getPlayerConnectionStatusAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPlayerConnectionStatusResult> getPlayerConnectionStatusAsync(GetPlayerConnectionStatusRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPlayerConnectionStatusRequest, GetPlayerConnectionStatusResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSnapshotResult> getSnapshotAsync(GetSnapshotRequest request) {

        return getSnapshotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSnapshotResult> getSnapshotAsync(GetSnapshotRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSnapshotRequest, GetSnapshotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetStageResult> getStageAsync(GetStageRequest request) {

        return getStageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStageResult> getStageAsync(GetStageRequest request,
            com.amazonaws.handlers.AsyncHandler<GetStageRequest, GetStageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetStageDeploymentResult> getStageDeploymentAsync(GetStageDeploymentRequest request) {

        return getStageDeploymentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStageDeploymentResult> getStageDeploymentAsync(GetStageDeploymentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetStageDeploymentRequest, GetStageDeploymentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ImportGameConfigurationResult> importGameConfigurationAsync(ImportGameConfigurationRequest request) {

        return importGameConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ImportGameConfigurationResult> importGameConfigurationAsync(ImportGameConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<ImportGameConfigurationRequest, ImportGameConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListExtensionVersionsResult> listExtensionVersionsAsync(ListExtensionVersionsRequest request) {

        return listExtensionVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListExtensionVersionsResult> listExtensionVersionsAsync(ListExtensionVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListExtensionVersionsRequest, ListExtensionVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListExtensionsResult> listExtensionsAsync(ListExtensionsRequest request) {

        return listExtensionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListExtensionsResult> listExtensionsAsync(ListExtensionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListExtensionsRequest, ListExtensionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListGamesResult> listGamesAsync(ListGamesRequest request) {

        return listGamesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListGamesResult> listGamesAsync(ListGamesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListGamesRequest, ListGamesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListGeneratedCodeJobsResult> listGeneratedCodeJobsAsync(ListGeneratedCodeJobsRequest request) {

        return listGeneratedCodeJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListGeneratedCodeJobsResult> listGeneratedCodeJobsAsync(ListGeneratedCodeJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListGeneratedCodeJobsRequest, ListGeneratedCodeJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSnapshotsResult> listSnapshotsAsync(ListSnapshotsRequest request) {

        return listSnapshotsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSnapshotsResult> listSnapshotsAsync(ListSnapshotsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSnapshotsRequest, ListSnapshotsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStageDeploymentsResult> listStageDeploymentsAsync(ListStageDeploymentsRequest request) {

        return listStageDeploymentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStageDeploymentsResult> listStageDeploymentsAsync(ListStageDeploymentsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStageDeploymentsRequest, ListStageDeploymentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStagesResult> listStagesAsync(ListStagesRequest request) {

        return listStagesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStagesResult> listStagesAsync(ListStagesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStagesRequest, ListStagesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartGeneratedCodeJobResult> startGeneratedCodeJobAsync(StartGeneratedCodeJobRequest request) {

        return startGeneratedCodeJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartGeneratedCodeJobResult> startGeneratedCodeJobAsync(StartGeneratedCodeJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartGeneratedCodeJobRequest, StartGeneratedCodeJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartStageDeploymentResult> startStageDeploymentAsync(StartStageDeploymentRequest request) {

        return startStageDeploymentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartStageDeploymentResult> startStageDeploymentAsync(StartStageDeploymentRequest request,
            com.amazonaws.handlers.AsyncHandler<StartStageDeploymentRequest, StartStageDeploymentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateGameResult> updateGameAsync(UpdateGameRequest request) {

        return updateGameAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateGameResult> updateGameAsync(UpdateGameRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateGameRequest, UpdateGameResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateGameConfigurationResult> updateGameConfigurationAsync(UpdateGameConfigurationRequest request) {

        return updateGameConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateGameConfigurationResult> updateGameConfigurationAsync(UpdateGameConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateGameConfigurationRequest, UpdateGameConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSnapshotResult> updateSnapshotAsync(UpdateSnapshotRequest request) {

        return updateSnapshotAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSnapshotResult> updateSnapshotAsync(UpdateSnapshotRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSnapshotRequest, UpdateSnapshotResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateStageResult> updateStageAsync(UpdateStageRequest request) {

        return updateStageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateStageResult> updateStageAsync(UpdateStageRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateStageRequest, UpdateStageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
