/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gamelift.model.GameServerGroupAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SuspendGameServerGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String gameServerGroupName;
    private List<String> suspendActions;

    public void setGameServerGroupName(String gameServerGroupName) {
        this.gameServerGroupName = gameServerGroupName;
    }

    public String getGameServerGroupName() {
        return this.gameServerGroupName;
    }

    public SuspendGameServerGroupRequest withGameServerGroupName(String gameServerGroupName) {
        this.setGameServerGroupName(gameServerGroupName);
        return this;
    }

    public List<String> getSuspendActions() {
        return this.suspendActions;
    }

    public void setSuspendActions(Collection<String> suspendActions) {
        if (suspendActions == null) {
            this.suspendActions = null;
            return;
        }
        this.suspendActions = new ArrayList<String>(suspendActions);
    }

    public SuspendGameServerGroupRequest withSuspendActions(String ... suspendActions) {
        if (this.suspendActions == null) {
            this.setSuspendActions(new ArrayList<String>(suspendActions.length));
        }
        for (String ele : suspendActions) {
            this.suspendActions.add(ele);
        }
        return this;
    }

    public SuspendGameServerGroupRequest withSuspendActions(Collection<String> suspendActions) {
        this.setSuspendActions(suspendActions);
        return this;
    }

    public SuspendGameServerGroupRequest withSuspendActions(GameServerGroupAction ... suspendActions) {
        ArrayList<String> suspendActionsCopy = new ArrayList<String>(suspendActions.length);
        for (GameServerGroupAction value : suspendActions) {
            suspendActionsCopy.add(value.toString());
        }
        if (this.getSuspendActions() == null) {
            this.setSuspendActions(suspendActionsCopy);
        } else {
            this.getSuspendActions().addAll(suspendActionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGameServerGroupName() != null) {
            sb.append("GameServerGroupName: ").append(this.getGameServerGroupName()).append(",");
        }
        if (this.getSuspendActions() != null) {
            sb.append("SuspendActions: ").append(this.getSuspendActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendGameServerGroupRequest)) {
            return false;
        }
        SuspendGameServerGroupRequest other = (SuspendGameServerGroupRequest)obj;
        if (other.getGameServerGroupName() == null ^ this.getGameServerGroupName() == null) {
            return false;
        }
        if (other.getGameServerGroupName() != null && !other.getGameServerGroupName().equals(this.getGameServerGroupName())) {
            return false;
        }
        if (other.getSuspendActions() == null ^ this.getSuspendActions() == null) {
            return false;
        }
        return other.getSuspendActions() == null || other.getSuspendActions().equals(this.getSuspendActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGameServerGroupName() == null ? 0 : this.getGameServerGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getSuspendActions() == null ? 0 : this.getSuspendActions().hashCode());
        return hashCode;
    }

    public SuspendGameServerGroupRequest clone() {
        return (SuspendGameServerGroupRequest)super.clone();
    }
}

