/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.gamelift.model.GameServer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListGameServersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<GameServer> gameServers;
    private String nextToken;

    public List<GameServer> getGameServers() {
        return this.gameServers;
    }

    public void setGameServers(Collection<GameServer> gameServers) {
        if (gameServers == null) {
            this.gameServers = null;
            return;
        }
        this.gameServers = new ArrayList<GameServer>(gameServers);
    }

    public ListGameServersResult withGameServers(GameServer ... gameServers) {
        if (this.gameServers == null) {
            this.setGameServers(new ArrayList<GameServer>(gameServers.length));
        }
        for (GameServer ele : gameServers) {
            this.gameServers.add(ele);
        }
        return this;
    }

    public ListGameServersResult withGameServers(Collection<GameServer> gameServers) {
        this.setGameServers(gameServers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListGameServersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGameServers() != null) {
            sb.append("GameServers: ").append(this.getGameServers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGameServersResult)) {
            return false;
        }
        ListGameServersResult other = (ListGameServersResult)obj;
        if (other.getGameServers() == null ^ this.getGameServers() == null) {
            return false;
        }
        if (other.getGameServers() != null && !other.getGameServers().equals(this.getGameServers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGameServers() == null ? 0 : this.getGameServers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListGameServersResult clone() {
        try {
            return (ListGameServersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

