/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.NfsVersion;
import com.amazonaws.services.fsx.model.transform.FileCacheNFSConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileCacheNFSConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String version;
    private List<String> dnsIps;

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public FileCacheNFSConfiguration withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public FileCacheNFSConfiguration withVersion(NfsVersion version) {
        this.version = version.toString();
        return this;
    }

    public List<String> getDnsIps() {
        return this.dnsIps;
    }

    public void setDnsIps(Collection<String> dnsIps) {
        if (dnsIps == null) {
            this.dnsIps = null;
            return;
        }
        this.dnsIps = new ArrayList<String>(dnsIps);
    }

    public FileCacheNFSConfiguration withDnsIps(String ... dnsIps) {
        if (this.dnsIps == null) {
            this.setDnsIps(new ArrayList<String>(dnsIps.length));
        }
        for (String ele : dnsIps) {
            this.dnsIps.add(ele);
        }
        return this;
    }

    public FileCacheNFSConfiguration withDnsIps(Collection<String> dnsIps) {
        this.setDnsIps(dnsIps);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getDnsIps() != null) {
            sb.append("DnsIps: ").append(this.getDnsIps());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileCacheNFSConfiguration)) {
            return false;
        }
        FileCacheNFSConfiguration other = (FileCacheNFSConfiguration)obj;
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getDnsIps() == null ^ this.getDnsIps() == null) {
            return false;
        }
        return other.getDnsIps() == null || other.getDnsIps().equals(this.getDnsIps());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDnsIps() == null ? 0 : this.getDnsIps().hashCode());
        return hashCode;
    }

    public FileCacheNFSConfiguration clone() {
        try {
            return (FileCacheNFSConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileCacheNFSConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

