/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.DiskIopsConfiguration;
import com.amazonaws.services.fsx.model.FileSystemEndpoints;
import com.amazonaws.services.fsx.model.OntapDeploymentType;
import com.amazonaws.services.fsx.model.transform.OntapFileSystemConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OntapFileSystemConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer automaticBackupRetentionDays;
    private String dailyAutomaticBackupStartTime;
    private String deploymentType;
    private String endpointIpAddressRange;
    private FileSystemEndpoints endpoints;
    private DiskIopsConfiguration diskIopsConfiguration;
    private String preferredSubnetId;
    private List<String> routeTableIds;
    private Integer throughputCapacity;
    private String weeklyMaintenanceStartTime;
    private String fsxAdminPassword;
    private Integer hAPairs;
    private Integer throughputCapacityPerHAPair;

    public void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
        this.automaticBackupRetentionDays = automaticBackupRetentionDays;
    }

    public Integer getAutomaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public OntapFileSystemConfiguration withAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
        this.setAutomaticBackupRetentionDays(automaticBackupRetentionDays);
        return this;
    }

    public void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
        this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
    }

    public String getDailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public OntapFileSystemConfiguration withDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
        this.setDailyAutomaticBackupStartTime(dailyAutomaticBackupStartTime);
        return this;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String getDeploymentType() {
        return this.deploymentType;
    }

    public OntapFileSystemConfiguration withDeploymentType(String deploymentType) {
        this.setDeploymentType(deploymentType);
        return this;
    }

    public OntapFileSystemConfiguration withDeploymentType(OntapDeploymentType deploymentType) {
        this.deploymentType = deploymentType.toString();
        return this;
    }

    public void setEndpointIpAddressRange(String endpointIpAddressRange) {
        this.endpointIpAddressRange = endpointIpAddressRange;
    }

    public String getEndpointIpAddressRange() {
        return this.endpointIpAddressRange;
    }

    public OntapFileSystemConfiguration withEndpointIpAddressRange(String endpointIpAddressRange) {
        this.setEndpointIpAddressRange(endpointIpAddressRange);
        return this;
    }

    public void setEndpoints(FileSystemEndpoints endpoints) {
        this.endpoints = endpoints;
    }

    public FileSystemEndpoints getEndpoints() {
        return this.endpoints;
    }

    public OntapFileSystemConfiguration withEndpoints(FileSystemEndpoints endpoints) {
        this.setEndpoints(endpoints);
        return this;
    }

    public void setDiskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
        this.diskIopsConfiguration = diskIopsConfiguration;
    }

    public DiskIopsConfiguration getDiskIopsConfiguration() {
        return this.diskIopsConfiguration;
    }

    public OntapFileSystemConfiguration withDiskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
        this.setDiskIopsConfiguration(diskIopsConfiguration);
        return this;
    }

    public void setPreferredSubnetId(String preferredSubnetId) {
        this.preferredSubnetId = preferredSubnetId;
    }

    public String getPreferredSubnetId() {
        return this.preferredSubnetId;
    }

    public OntapFileSystemConfiguration withPreferredSubnetId(String preferredSubnetId) {
        this.setPreferredSubnetId(preferredSubnetId);
        return this;
    }

    public List<String> getRouteTableIds() {
        return this.routeTableIds;
    }

    public void setRouteTableIds(Collection<String> routeTableIds) {
        if (routeTableIds == null) {
            this.routeTableIds = null;
            return;
        }
        this.routeTableIds = new ArrayList<String>(routeTableIds);
    }

    public OntapFileSystemConfiguration withRouteTableIds(String ... routeTableIds) {
        if (this.routeTableIds == null) {
            this.setRouteTableIds(new ArrayList<String>(routeTableIds.length));
        }
        for (String ele : routeTableIds) {
            this.routeTableIds.add(ele);
        }
        return this;
    }

    public OntapFileSystemConfiguration withRouteTableIds(Collection<String> routeTableIds) {
        this.setRouteTableIds(routeTableIds);
        return this;
    }

    public void setThroughputCapacity(Integer throughputCapacity) {
        this.throughputCapacity = throughputCapacity;
    }

    public Integer getThroughputCapacity() {
        return this.throughputCapacity;
    }

    public OntapFileSystemConfiguration withThroughputCapacity(Integer throughputCapacity) {
        this.setThroughputCapacity(throughputCapacity);
        return this;
    }

    public void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
        this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
    }

    public String getWeeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public OntapFileSystemConfiguration withWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
        this.setWeeklyMaintenanceStartTime(weeklyMaintenanceStartTime);
        return this;
    }

    public void setFsxAdminPassword(String fsxAdminPassword) {
        this.fsxAdminPassword = fsxAdminPassword;
    }

    public String getFsxAdminPassword() {
        return this.fsxAdminPassword;
    }

    public OntapFileSystemConfiguration withFsxAdminPassword(String fsxAdminPassword) {
        this.setFsxAdminPassword(fsxAdminPassword);
        return this;
    }

    public void setHAPairs(Integer hAPairs) {
        this.hAPairs = hAPairs;
    }

    public Integer getHAPairs() {
        return this.hAPairs;
    }

    public OntapFileSystemConfiguration withHAPairs(Integer hAPairs) {
        this.setHAPairs(hAPairs);
        return this;
    }

    public void setThroughputCapacityPerHAPair(Integer throughputCapacityPerHAPair) {
        this.throughputCapacityPerHAPair = throughputCapacityPerHAPair;
    }

    public Integer getThroughputCapacityPerHAPair() {
        return this.throughputCapacityPerHAPair;
    }

    public OntapFileSystemConfiguration withThroughputCapacityPerHAPair(Integer throughputCapacityPerHAPair) {
        this.setThroughputCapacityPerHAPair(throughputCapacityPerHAPair);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutomaticBackupRetentionDays() != null) {
            sb.append("AutomaticBackupRetentionDays: ").append(this.getAutomaticBackupRetentionDays()).append(",");
        }
        if (this.getDailyAutomaticBackupStartTime() != null) {
            sb.append("DailyAutomaticBackupStartTime: ").append(this.getDailyAutomaticBackupStartTime()).append(",");
        }
        if (this.getDeploymentType() != null) {
            sb.append("DeploymentType: ").append(this.getDeploymentType()).append(",");
        }
        if (this.getEndpointIpAddressRange() != null) {
            sb.append("EndpointIpAddressRange: ").append(this.getEndpointIpAddressRange()).append(",");
        }
        if (this.getEndpoints() != null) {
            sb.append("Endpoints: ").append(this.getEndpoints()).append(",");
        }
        if (this.getDiskIopsConfiguration() != null) {
            sb.append("DiskIopsConfiguration: ").append(this.getDiskIopsConfiguration()).append(",");
        }
        if (this.getPreferredSubnetId() != null) {
            sb.append("PreferredSubnetId: ").append(this.getPreferredSubnetId()).append(",");
        }
        if (this.getRouteTableIds() != null) {
            sb.append("RouteTableIds: ").append(this.getRouteTableIds()).append(",");
        }
        if (this.getThroughputCapacity() != null) {
            sb.append("ThroughputCapacity: ").append(this.getThroughputCapacity()).append(",");
        }
        if (this.getWeeklyMaintenanceStartTime() != null) {
            sb.append("WeeklyMaintenanceStartTime: ").append(this.getWeeklyMaintenanceStartTime()).append(",");
        }
        if (this.getFsxAdminPassword() != null) {
            sb.append("FsxAdminPassword: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getHAPairs() != null) {
            sb.append("HAPairs: ").append(this.getHAPairs()).append(",");
        }
        if (this.getThroughputCapacityPerHAPair() != null) {
            sb.append("ThroughputCapacityPerHAPair: ").append(this.getThroughputCapacityPerHAPair());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OntapFileSystemConfiguration)) {
            return false;
        }
        OntapFileSystemConfiguration other = (OntapFileSystemConfiguration)obj;
        if (other.getAutomaticBackupRetentionDays() == null ^ this.getAutomaticBackupRetentionDays() == null) {
            return false;
        }
        if (other.getAutomaticBackupRetentionDays() != null && !other.getAutomaticBackupRetentionDays().equals(this.getAutomaticBackupRetentionDays())) {
            return false;
        }
        if (other.getDailyAutomaticBackupStartTime() == null ^ this.getDailyAutomaticBackupStartTime() == null) {
            return false;
        }
        if (other.getDailyAutomaticBackupStartTime() != null && !other.getDailyAutomaticBackupStartTime().equals(this.getDailyAutomaticBackupStartTime())) {
            return false;
        }
        if (other.getDeploymentType() == null ^ this.getDeploymentType() == null) {
            return false;
        }
        if (other.getDeploymentType() != null && !other.getDeploymentType().equals(this.getDeploymentType())) {
            return false;
        }
        if (other.getEndpointIpAddressRange() == null ^ this.getEndpointIpAddressRange() == null) {
            return false;
        }
        if (other.getEndpointIpAddressRange() != null && !other.getEndpointIpAddressRange().equals(this.getEndpointIpAddressRange())) {
            return false;
        }
        if (other.getEndpoints() == null ^ this.getEndpoints() == null) {
            return false;
        }
        if (other.getEndpoints() != null && !other.getEndpoints().equals(this.getEndpoints())) {
            return false;
        }
        if (other.getDiskIopsConfiguration() == null ^ this.getDiskIopsConfiguration() == null) {
            return false;
        }
        if (other.getDiskIopsConfiguration() != null && !other.getDiskIopsConfiguration().equals(this.getDiskIopsConfiguration())) {
            return false;
        }
        if (other.getPreferredSubnetId() == null ^ this.getPreferredSubnetId() == null) {
            return false;
        }
        if (other.getPreferredSubnetId() != null && !other.getPreferredSubnetId().equals(this.getPreferredSubnetId())) {
            return false;
        }
        if (other.getRouteTableIds() == null ^ this.getRouteTableIds() == null) {
            return false;
        }
        if (other.getRouteTableIds() != null && !other.getRouteTableIds().equals(this.getRouteTableIds())) {
            return false;
        }
        if (other.getThroughputCapacity() == null ^ this.getThroughputCapacity() == null) {
            return false;
        }
        if (other.getThroughputCapacity() != null && !other.getThroughputCapacity().equals(this.getThroughputCapacity())) {
            return false;
        }
        if (other.getWeeklyMaintenanceStartTime() == null ^ this.getWeeklyMaintenanceStartTime() == null) {
            return false;
        }
        if (other.getWeeklyMaintenanceStartTime() != null && !other.getWeeklyMaintenanceStartTime().equals(this.getWeeklyMaintenanceStartTime())) {
            return false;
        }
        if (other.getFsxAdminPassword() == null ^ this.getFsxAdminPassword() == null) {
            return false;
        }
        if (other.getFsxAdminPassword() != null && !other.getFsxAdminPassword().equals(this.getFsxAdminPassword())) {
            return false;
        }
        if (other.getHAPairs() == null ^ this.getHAPairs() == null) {
            return false;
        }
        if (other.getHAPairs() != null && !other.getHAPairs().equals(this.getHAPairs())) {
            return false;
        }
        if (other.getThroughputCapacityPerHAPair() == null ^ this.getThroughputCapacityPerHAPair() == null) {
            return false;
        }
        return other.getThroughputCapacityPerHAPair() == null || other.getThroughputCapacityPerHAPair().equals(this.getThroughputCapacityPerHAPair());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutomaticBackupRetentionDays() == null ? 0 : this.getAutomaticBackupRetentionDays().hashCode());
        hashCode = 31 * hashCode + (this.getDailyAutomaticBackupStartTime() == null ? 0 : this.getDailyAutomaticBackupStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentType() == null ? 0 : this.getDeploymentType().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointIpAddressRange() == null ? 0 : this.getEndpointIpAddressRange().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoints() == null ? 0 : this.getEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getDiskIopsConfiguration() == null ? 0 : this.getDiskIopsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredSubnetId() == null ? 0 : this.getPreferredSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getRouteTableIds() == null ? 0 : this.getRouteTableIds().hashCode());
        hashCode = 31 * hashCode + (this.getThroughputCapacity() == null ? 0 : this.getThroughputCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getWeeklyMaintenanceStartTime() == null ? 0 : this.getWeeklyMaintenanceStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getFsxAdminPassword() == null ? 0 : this.getFsxAdminPassword().hashCode());
        hashCode = 31 * hashCode + (this.getHAPairs() == null ? 0 : this.getHAPairs().hashCode());
        hashCode = 31 * hashCode + (this.getThroughputCapacityPerHAPair() == null ? 0 : this.getThroughputCapacityPerHAPair().hashCode());
        return hashCode;
    }

    public OntapFileSystemConfiguration clone() {
        try {
            return (OntapFileSystemConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OntapFileSystemConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

