/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.OpenZFSDataCompressionType;
import com.amazonaws.services.fsx.model.OpenZFSNfsExport;
import com.amazonaws.services.fsx.model.OpenZFSOriginSnapshotConfiguration;
import com.amazonaws.services.fsx.model.OpenZFSUserOrGroupQuota;
import com.amazonaws.services.fsx.model.transform.OpenZFSVolumeConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OpenZFSVolumeConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String parentVolumeId;
    private String volumePath;
    private Integer storageCapacityReservationGiB;
    private Integer storageCapacityQuotaGiB;
    private String dataCompressionType;
    private Boolean copyTagsToSnapshots;
    private OpenZFSOriginSnapshotConfiguration originSnapshot;
    private Boolean readOnly;
    private List<OpenZFSNfsExport> nfsExports;
    private List<OpenZFSUserOrGroupQuota> userAndGroupQuotas;

    public void setParentVolumeId(String parentVolumeId) {
        this.parentVolumeId = parentVolumeId;
    }

    public String getParentVolumeId() {
        return this.parentVolumeId;
    }

    public OpenZFSVolumeConfiguration withParentVolumeId(String parentVolumeId) {
        this.setParentVolumeId(parentVolumeId);
        return this;
    }

    public void setVolumePath(String volumePath) {
        this.volumePath = volumePath;
    }

    public String getVolumePath() {
        return this.volumePath;
    }

    public OpenZFSVolumeConfiguration withVolumePath(String volumePath) {
        this.setVolumePath(volumePath);
        return this;
    }

    public void setStorageCapacityReservationGiB(Integer storageCapacityReservationGiB) {
        this.storageCapacityReservationGiB = storageCapacityReservationGiB;
    }

    public Integer getStorageCapacityReservationGiB() {
        return this.storageCapacityReservationGiB;
    }

    public OpenZFSVolumeConfiguration withStorageCapacityReservationGiB(Integer storageCapacityReservationGiB) {
        this.setStorageCapacityReservationGiB(storageCapacityReservationGiB);
        return this;
    }

    public void setStorageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
        this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
    }

    public Integer getStorageCapacityQuotaGiB() {
        return this.storageCapacityQuotaGiB;
    }

    public OpenZFSVolumeConfiguration withStorageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
        this.setStorageCapacityQuotaGiB(storageCapacityQuotaGiB);
        return this;
    }

    public void setDataCompressionType(String dataCompressionType) {
        this.dataCompressionType = dataCompressionType;
    }

    public String getDataCompressionType() {
        return this.dataCompressionType;
    }

    public OpenZFSVolumeConfiguration withDataCompressionType(String dataCompressionType) {
        this.setDataCompressionType(dataCompressionType);
        return this;
    }

    public OpenZFSVolumeConfiguration withDataCompressionType(OpenZFSDataCompressionType dataCompressionType) {
        this.dataCompressionType = dataCompressionType.toString();
        return this;
    }

    public void setCopyTagsToSnapshots(Boolean copyTagsToSnapshots) {
        this.copyTagsToSnapshots = copyTagsToSnapshots;
    }

    public Boolean getCopyTagsToSnapshots() {
        return this.copyTagsToSnapshots;
    }

    public OpenZFSVolumeConfiguration withCopyTagsToSnapshots(Boolean copyTagsToSnapshots) {
        this.setCopyTagsToSnapshots(copyTagsToSnapshots);
        return this;
    }

    public Boolean isCopyTagsToSnapshots() {
        return this.copyTagsToSnapshots;
    }

    public void setOriginSnapshot(OpenZFSOriginSnapshotConfiguration originSnapshot) {
        this.originSnapshot = originSnapshot;
    }

    public OpenZFSOriginSnapshotConfiguration getOriginSnapshot() {
        return this.originSnapshot;
    }

    public OpenZFSVolumeConfiguration withOriginSnapshot(OpenZFSOriginSnapshotConfiguration originSnapshot) {
        this.setOriginSnapshot(originSnapshot);
        return this;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public OpenZFSVolumeConfiguration withReadOnly(Boolean readOnly) {
        this.setReadOnly(readOnly);
        return this;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public List<OpenZFSNfsExport> getNfsExports() {
        return this.nfsExports;
    }

    public void setNfsExports(Collection<OpenZFSNfsExport> nfsExports) {
        if (nfsExports == null) {
            this.nfsExports = null;
            return;
        }
        this.nfsExports = new ArrayList<OpenZFSNfsExport>(nfsExports);
    }

    public OpenZFSVolumeConfiguration withNfsExports(OpenZFSNfsExport ... nfsExports) {
        if (this.nfsExports == null) {
            this.setNfsExports(new ArrayList<OpenZFSNfsExport>(nfsExports.length));
        }
        for (OpenZFSNfsExport ele : nfsExports) {
            this.nfsExports.add(ele);
        }
        return this;
    }

    public OpenZFSVolumeConfiguration withNfsExports(Collection<OpenZFSNfsExport> nfsExports) {
        this.setNfsExports(nfsExports);
        return this;
    }

    public List<OpenZFSUserOrGroupQuota> getUserAndGroupQuotas() {
        return this.userAndGroupQuotas;
    }

    public void setUserAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota> userAndGroupQuotas) {
        if (userAndGroupQuotas == null) {
            this.userAndGroupQuotas = null;
            return;
        }
        this.userAndGroupQuotas = new ArrayList<OpenZFSUserOrGroupQuota>(userAndGroupQuotas);
    }

    public OpenZFSVolumeConfiguration withUserAndGroupQuotas(OpenZFSUserOrGroupQuota ... userAndGroupQuotas) {
        if (this.userAndGroupQuotas == null) {
            this.setUserAndGroupQuotas(new ArrayList<OpenZFSUserOrGroupQuota>(userAndGroupQuotas.length));
        }
        for (OpenZFSUserOrGroupQuota ele : userAndGroupQuotas) {
            this.userAndGroupQuotas.add(ele);
        }
        return this;
    }

    public OpenZFSVolumeConfiguration withUserAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota> userAndGroupQuotas) {
        this.setUserAndGroupQuotas(userAndGroupQuotas);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getParentVolumeId() != null) {
            sb.append("ParentVolumeId: ").append(this.getParentVolumeId()).append(",");
        }
        if (this.getVolumePath() != null) {
            sb.append("VolumePath: ").append(this.getVolumePath()).append(",");
        }
        if (this.getStorageCapacityReservationGiB() != null) {
            sb.append("StorageCapacityReservationGiB: ").append(this.getStorageCapacityReservationGiB()).append(",");
        }
        if (this.getStorageCapacityQuotaGiB() != null) {
            sb.append("StorageCapacityQuotaGiB: ").append(this.getStorageCapacityQuotaGiB()).append(",");
        }
        if (this.getDataCompressionType() != null) {
            sb.append("DataCompressionType: ").append(this.getDataCompressionType()).append(",");
        }
        if (this.getCopyTagsToSnapshots() != null) {
            sb.append("CopyTagsToSnapshots: ").append(this.getCopyTagsToSnapshots()).append(",");
        }
        if (this.getOriginSnapshot() != null) {
            sb.append("OriginSnapshot: ").append(this.getOriginSnapshot()).append(",");
        }
        if (this.getReadOnly() != null) {
            sb.append("ReadOnly: ").append(this.getReadOnly()).append(",");
        }
        if (this.getNfsExports() != null) {
            sb.append("NfsExports: ").append(this.getNfsExports()).append(",");
        }
        if (this.getUserAndGroupQuotas() != null) {
            sb.append("UserAndGroupQuotas: ").append(this.getUserAndGroupQuotas());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSVolumeConfiguration)) {
            return false;
        }
        OpenZFSVolumeConfiguration other = (OpenZFSVolumeConfiguration)obj;
        if (other.getParentVolumeId() == null ^ this.getParentVolumeId() == null) {
            return false;
        }
        if (other.getParentVolumeId() != null && !other.getParentVolumeId().equals(this.getParentVolumeId())) {
            return false;
        }
        if (other.getVolumePath() == null ^ this.getVolumePath() == null) {
            return false;
        }
        if (other.getVolumePath() != null && !other.getVolumePath().equals(this.getVolumePath())) {
            return false;
        }
        if (other.getStorageCapacityReservationGiB() == null ^ this.getStorageCapacityReservationGiB() == null) {
            return false;
        }
        if (other.getStorageCapacityReservationGiB() != null && !other.getStorageCapacityReservationGiB().equals(this.getStorageCapacityReservationGiB())) {
            return false;
        }
        if (other.getStorageCapacityQuotaGiB() == null ^ this.getStorageCapacityQuotaGiB() == null) {
            return false;
        }
        if (other.getStorageCapacityQuotaGiB() != null && !other.getStorageCapacityQuotaGiB().equals(this.getStorageCapacityQuotaGiB())) {
            return false;
        }
        if (other.getDataCompressionType() == null ^ this.getDataCompressionType() == null) {
            return false;
        }
        if (other.getDataCompressionType() != null && !other.getDataCompressionType().equals(this.getDataCompressionType())) {
            return false;
        }
        if (other.getCopyTagsToSnapshots() == null ^ this.getCopyTagsToSnapshots() == null) {
            return false;
        }
        if (other.getCopyTagsToSnapshots() != null && !other.getCopyTagsToSnapshots().equals(this.getCopyTagsToSnapshots())) {
            return false;
        }
        if (other.getOriginSnapshot() == null ^ this.getOriginSnapshot() == null) {
            return false;
        }
        if (other.getOriginSnapshot() != null && !other.getOriginSnapshot().equals(this.getOriginSnapshot())) {
            return false;
        }
        if (other.getReadOnly() == null ^ this.getReadOnly() == null) {
            return false;
        }
        if (other.getReadOnly() != null && !other.getReadOnly().equals(this.getReadOnly())) {
            return false;
        }
        if (other.getNfsExports() == null ^ this.getNfsExports() == null) {
            return false;
        }
        if (other.getNfsExports() != null && !other.getNfsExports().equals(this.getNfsExports())) {
            return false;
        }
        if (other.getUserAndGroupQuotas() == null ^ this.getUserAndGroupQuotas() == null) {
            return false;
        }
        return other.getUserAndGroupQuotas() == null || other.getUserAndGroupQuotas().equals(this.getUserAndGroupQuotas());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getParentVolumeId() == null ? 0 : this.getParentVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getVolumePath() == null ? 0 : this.getVolumePath().hashCode());
        hashCode = 31 * hashCode + (this.getStorageCapacityReservationGiB() == null ? 0 : this.getStorageCapacityReservationGiB().hashCode());
        hashCode = 31 * hashCode + (this.getStorageCapacityQuotaGiB() == null ? 0 : this.getStorageCapacityQuotaGiB().hashCode());
        hashCode = 31 * hashCode + (this.getDataCompressionType() == null ? 0 : this.getDataCompressionType().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTagsToSnapshots() == null ? 0 : this.getCopyTagsToSnapshots().hashCode());
        hashCode = 31 * hashCode + (this.getOriginSnapshot() == null ? 0 : this.getOriginSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.getReadOnly() == null ? 0 : this.getReadOnly().hashCode());
        hashCode = 31 * hashCode + (this.getNfsExports() == null ? 0 : this.getNfsExports().hashCode());
        hashCode = 31 * hashCode + (this.getUserAndGroupQuotas() == null ? 0 : this.getUserAndGroupQuotas().hashCode());
        return hashCode;
    }

    public OpenZFSVolumeConfiguration clone() {
        try {
            return (OpenZFSVolumeConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OpenZFSVolumeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

