/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.fsx.AmazonFSx;
import com.amazonaws.services.fsx.AmazonFSxClientBuilder;
import com.amazonaws.services.fsx.model.ActiveDirectoryErrorException;
import com.amazonaws.services.fsx.model.AmazonFSxException;
import com.amazonaws.services.fsx.model.BackupInProgressException;
import com.amazonaws.services.fsx.model.BackupNotFoundException;
import com.amazonaws.services.fsx.model.BackupRestoringException;
import com.amazonaws.services.fsx.model.BadRequestException;
import com.amazonaws.services.fsx.model.CreateBackupRequest;
import com.amazonaws.services.fsx.model.CreateBackupResult;
import com.amazonaws.services.fsx.model.CreateFileSystemFromBackupRequest;
import com.amazonaws.services.fsx.model.CreateFileSystemFromBackupResult;
import com.amazonaws.services.fsx.model.CreateFileSystemRequest;
import com.amazonaws.services.fsx.model.CreateFileSystemResult;
import com.amazonaws.services.fsx.model.DeleteBackupRequest;
import com.amazonaws.services.fsx.model.DeleteBackupResult;
import com.amazonaws.services.fsx.model.DeleteFileSystemRequest;
import com.amazonaws.services.fsx.model.DeleteFileSystemResult;
import com.amazonaws.services.fsx.model.DescribeBackupsRequest;
import com.amazonaws.services.fsx.model.DescribeBackupsResult;
import com.amazonaws.services.fsx.model.DescribeFileSystemsRequest;
import com.amazonaws.services.fsx.model.DescribeFileSystemsResult;
import com.amazonaws.services.fsx.model.FileSystemNotFoundException;
import com.amazonaws.services.fsx.model.IncompatibleParameterErrorException;
import com.amazonaws.services.fsx.model.InternalServerErrorException;
import com.amazonaws.services.fsx.model.InvalidExportPathException;
import com.amazonaws.services.fsx.model.InvalidImportPathException;
import com.amazonaws.services.fsx.model.InvalidNetworkSettingsException;
import com.amazonaws.services.fsx.model.ListTagsForResourceRequest;
import com.amazonaws.services.fsx.model.ListTagsForResourceResult;
import com.amazonaws.services.fsx.model.MissingFileSystemConfigurationException;
import com.amazonaws.services.fsx.model.NotServiceResourceErrorException;
import com.amazonaws.services.fsx.model.ResourceDoesNotSupportTaggingException;
import com.amazonaws.services.fsx.model.ResourceNotFoundException;
import com.amazonaws.services.fsx.model.ServiceLimitExceededException;
import com.amazonaws.services.fsx.model.TagResourceRequest;
import com.amazonaws.services.fsx.model.TagResourceResult;
import com.amazonaws.services.fsx.model.UntagResourceRequest;
import com.amazonaws.services.fsx.model.UntagResourceResult;
import com.amazonaws.services.fsx.model.UpdateFileSystemRequest;
import com.amazonaws.services.fsx.model.UpdateFileSystemResult;
import com.amazonaws.services.fsx.model.transform.CreateBackupRequestProtocolMarshaller;
import com.amazonaws.services.fsx.model.transform.CreateBackupResultJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.CreateFileSystemFromBackupRequestProtocolMarshaller;
import com.amazonaws.services.fsx.model.transform.CreateFileSystemFromBackupResultJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.CreateFileSystemRequestProtocolMarshaller;
import com.amazonaws.services.fsx.model.transform.CreateFileSystemResultJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.DeleteBackupRequestProtocolMarshaller;
import com.amazonaws.services.fsx.model.transform.DeleteBackupResultJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.DeleteFileSystemRequestProtocolMarshaller;
import com.amazonaws.services.fsx.model.transform.DeleteFileSystemResultJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.DescribeBackupsRequestProtocolMarshaller;
import com.amazonaws.services.fsx.model.transform.DescribeBackupsResultJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.DescribeFileSystemsRequestProtocolMarshaller;
import com.amazonaws.services.fsx.model.transform.DescribeFileSystemsResultJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.fsx.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.fsx.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.fsx.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.UpdateFileSystemRequestProtocolMarshaller;
import com.amazonaws.services.fsx.model.transform.UpdateFileSystemResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonFSxClient
extends AmazonWebServiceClient
implements AmazonFSx {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonFSx.class);
    private static final String DEFAULT_SIGNING_NAME = "fsx";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceLimitExceeded").withModeledClass(ServiceLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFound").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotServiceResourceError").withModeledClass(NotServiceResourceErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidImportPath").withModeledClass(InvalidImportPathException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNetworkSettings").withModeledClass(InvalidNetworkSettingsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingFileSystemConfiguration").withModeledClass(MissingFileSystemConfigurationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemNotFound").withModeledClass(FileSystemNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BackupRestoring").withModeledClass(BackupRestoringException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IncompatibleParameterError").withModeledClass(IncompatibleParameterErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BackupInProgress").withModeledClass(BackupInProgressException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidExportPath").withModeledClass(InvalidExportPathException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceDoesNotSupportTagging").withModeledClass(ResourceDoesNotSupportTaggingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BackupNotFound").withModeledClass(BackupNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ActiveDirectoryError").withModeledClass(ActiveDirectoryErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequest").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).withBaseServiceExceptionClass(AmazonFSxException.class));

    public static AmazonFSxClientBuilder builder() {
        return AmazonFSxClientBuilder.standard();
    }

    AmazonFSxClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonFSxClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("fsx.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/fsx/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/fsx/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateBackupResult createBackup(CreateBackupRequest request) {
        request = (CreateBackupRequest)this.beforeClientExecution(request);
        return this.executeCreateBackup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBackupResult executeCreateBackup(CreateBackupRequest createBackupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBackupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBackupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBackupRequestProtocolMarshaller(protocolFactory).marshall((CreateBackupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBackupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FSx");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateBackup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBackupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBackupResult createBackupResult = (CreateBackupResult)response.getAwsResponse();
            return createBackupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateFileSystemResult createFileSystem(CreateFileSystemRequest request) {
        request = (CreateFileSystemRequest)this.beforeClientExecution(request);
        return this.executeCreateFileSystem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateFileSystemResult executeCreateFileSystem(CreateFileSystemRequest createFileSystemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFileSystemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFileSystemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFileSystemRequestProtocolMarshaller(protocolFactory).marshall((CreateFileSystemRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFileSystemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FSx");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateFileSystem");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFileSystemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFileSystemResult createFileSystemResult = (CreateFileSystemResult)response.getAwsResponse();
            return createFileSystemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateFileSystemFromBackupResult createFileSystemFromBackup(CreateFileSystemFromBackupRequest request) {
        request = (CreateFileSystemFromBackupRequest)this.beforeClientExecution(request);
        return this.executeCreateFileSystemFromBackup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateFileSystemFromBackupResult executeCreateFileSystemFromBackup(CreateFileSystemFromBackupRequest createFileSystemFromBackupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFileSystemFromBackupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFileSystemFromBackupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFileSystemFromBackupRequestProtocolMarshaller(protocolFactory).marshall((CreateFileSystemFromBackupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFileSystemFromBackupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FSx");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateFileSystemFromBackup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFileSystemFromBackupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFileSystemFromBackupResult createFileSystemFromBackupResult = (CreateFileSystemFromBackupResult)response.getAwsResponse();
            return createFileSystemFromBackupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBackupResult deleteBackup(DeleteBackupRequest request) {
        request = (DeleteBackupRequest)this.beforeClientExecution(request);
        return this.executeDeleteBackup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBackupResult executeDeleteBackup(DeleteBackupRequest deleteBackupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackupRequestProtocolMarshaller(protocolFactory).marshall((DeleteBackupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBackupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FSx");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBackup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBackupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackupResult deleteBackupResult = (DeleteBackupResult)response.getAwsResponse();
            return deleteBackupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteFileSystemResult deleteFileSystem(DeleteFileSystemRequest request) {
        request = (DeleteFileSystemRequest)this.beforeClientExecution(request);
        return this.executeDeleteFileSystem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteFileSystemResult executeDeleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFileSystemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFileSystemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFileSystemRequestProtocolMarshaller(protocolFactory).marshall((DeleteFileSystemRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFileSystemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FSx");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteFileSystem");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFileSystemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFileSystemResult deleteFileSystemResult = (DeleteFileSystemResult)response.getAwsResponse();
            return deleteFileSystemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBackupsResult describeBackups(DescribeBackupsRequest request) {
        request = (DescribeBackupsRequest)this.beforeClientExecution(request);
        return this.executeDescribeBackups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBackupsResult executeDescribeBackups(DescribeBackupsRequest describeBackupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBackupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBackupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBackupsRequestProtocolMarshaller(protocolFactory).marshall((DescribeBackupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBackupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FSx");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBackups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBackupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBackupsResult describeBackupsResult = (DescribeBackupsResult)response.getAwsResponse();
            return describeBackupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFileSystemsResult describeFileSystems(DescribeFileSystemsRequest request) {
        request = (DescribeFileSystemsRequest)this.beforeClientExecution(request);
        return this.executeDescribeFileSystems(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFileSystemsResult executeDescribeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFileSystemsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFileSystemsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFileSystemsRequestProtocolMarshaller(protocolFactory).marshall((DescribeFileSystemsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFileSystemsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FSx");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeFileSystems");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFileSystemsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFileSystemsResult describeFileSystemsResult = (DescribeFileSystemsResult)response.getAwsResponse();
            return describeFileSystemsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FSx");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FSx");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FSx");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFileSystemResult updateFileSystem(UpdateFileSystemRequest request) {
        request = (UpdateFileSystemRequest)this.beforeClientExecution(request);
        return this.executeUpdateFileSystem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFileSystemResult executeUpdateFileSystem(UpdateFileSystemRequest updateFileSystemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFileSystemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFileSystemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFileSystemRequestProtocolMarshaller(protocolFactory).marshall((UpdateFileSystemRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFileSystemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FSx");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateFileSystem");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFileSystemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFileSystemResult updateFileSystemResult = (UpdateFileSystemResult)response.getAwsResponse();
            return updateFileSystemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

