/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.ModelOutputDataFormat;
import com.amazonaws.services.frauddetector.model.transform.ModelOutputConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ModelOutputConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String format;
    private Map<String, String> jsonKeyToVariableMap;
    private Map<String, String> csvIndexToVariableMap;

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public ModelOutputConfiguration withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public ModelOutputConfiguration withFormat(ModelOutputDataFormat format) {
        this.format = format.toString();
        return this;
    }

    public Map<String, String> getJsonKeyToVariableMap() {
        return this.jsonKeyToVariableMap;
    }

    public void setJsonKeyToVariableMap(Map<String, String> jsonKeyToVariableMap) {
        this.jsonKeyToVariableMap = jsonKeyToVariableMap;
    }

    public ModelOutputConfiguration withJsonKeyToVariableMap(Map<String, String> jsonKeyToVariableMap) {
        this.setJsonKeyToVariableMap(jsonKeyToVariableMap);
        return this;
    }

    public ModelOutputConfiguration addJsonKeyToVariableMapEntry(String key, String value) {
        if (null == this.jsonKeyToVariableMap) {
            this.jsonKeyToVariableMap = new HashMap<String, String>();
        }
        if (this.jsonKeyToVariableMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.jsonKeyToVariableMap.put(key, value);
        return this;
    }

    public ModelOutputConfiguration clearJsonKeyToVariableMapEntries() {
        this.jsonKeyToVariableMap = null;
        return this;
    }

    public Map<String, String> getCsvIndexToVariableMap() {
        return this.csvIndexToVariableMap;
    }

    public void setCsvIndexToVariableMap(Map<String, String> csvIndexToVariableMap) {
        this.csvIndexToVariableMap = csvIndexToVariableMap;
    }

    public ModelOutputConfiguration withCsvIndexToVariableMap(Map<String, String> csvIndexToVariableMap) {
        this.setCsvIndexToVariableMap(csvIndexToVariableMap);
        return this;
    }

    public ModelOutputConfiguration addCsvIndexToVariableMapEntry(String key, String value) {
        if (null == this.csvIndexToVariableMap) {
            this.csvIndexToVariableMap = new HashMap<String, String>();
        }
        if (this.csvIndexToVariableMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.csvIndexToVariableMap.put(key, value);
        return this;
    }

    public ModelOutputConfiguration clearCsvIndexToVariableMapEntries() {
        this.csvIndexToVariableMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getJsonKeyToVariableMap() != null) {
            sb.append("JsonKeyToVariableMap: ").append(this.getJsonKeyToVariableMap()).append(",");
        }
        if (this.getCsvIndexToVariableMap() != null) {
            sb.append("CsvIndexToVariableMap: ").append(this.getCsvIndexToVariableMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelOutputConfiguration)) {
            return false;
        }
        ModelOutputConfiguration other = (ModelOutputConfiguration)obj;
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getJsonKeyToVariableMap() == null ^ this.getJsonKeyToVariableMap() == null) {
            return false;
        }
        if (other.getJsonKeyToVariableMap() != null && !other.getJsonKeyToVariableMap().equals(this.getJsonKeyToVariableMap())) {
            return false;
        }
        if (other.getCsvIndexToVariableMap() == null ^ this.getCsvIndexToVariableMap() == null) {
            return false;
        }
        return other.getCsvIndexToVariableMap() == null || other.getCsvIndexToVariableMap().equals(this.getCsvIndexToVariableMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getJsonKeyToVariableMap() == null ? 0 : this.getJsonKeyToVariableMap().hashCode());
        hashCode = 31 * hashCode + (this.getCsvIndexToVariableMap() == null ? 0 : this.getCsvIndexToVariableMap().hashCode());
        return hashCode;
    }

    public ModelOutputConfiguration clone() {
        try {
            return (ModelOutputConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ModelOutputConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

