/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.frauddetector.model.ModelTypeEnum;
import com.amazonaws.services.frauddetector.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateModelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String modelId;
    private String modelType;
    private String description;
    private String eventTypeName;
    private List<Tag> tags;

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public CreateModelRequest withModelId(String modelId) {
        this.setModelId(modelId);
        return this;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public String getModelType() {
        return this.modelType;
    }

    public CreateModelRequest withModelType(String modelType) {
        this.setModelType(modelType);
        return this;
    }

    public CreateModelRequest withModelType(ModelTypeEnum modelType) {
        this.modelType = modelType.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateModelRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEventTypeName(String eventTypeName) {
        this.eventTypeName = eventTypeName;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public CreateModelRequest withEventTypeName(String eventTypeName) {
        this.setEventTypeName(eventTypeName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateModelRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateModelRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelId() != null) {
            sb.append("ModelId: ").append(this.getModelId()).append(",");
        }
        if (this.getModelType() != null) {
            sb.append("ModelType: ").append(this.getModelType()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEventTypeName() != null) {
            sb.append("EventTypeName: ").append(this.getEventTypeName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelRequest)) {
            return false;
        }
        CreateModelRequest other = (CreateModelRequest)obj;
        if (other.getModelId() == null ^ this.getModelId() == null) {
            return false;
        }
        if (other.getModelId() != null && !other.getModelId().equals(this.getModelId())) {
            return false;
        }
        if (other.getModelType() == null ^ this.getModelType() == null) {
            return false;
        }
        if (other.getModelType() != null && !other.getModelType().equals(this.getModelType())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEventTypeName() == null ^ this.getEventTypeName() == null) {
            return false;
        }
        if (other.getEventTypeName() != null && !other.getEventTypeName().equals(this.getEventTypeName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelId() == null ? 0 : this.getModelId().hashCode());
        hashCode = 31 * hashCode + (this.getModelType() == null ? 0 : this.getModelType().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEventTypeName() == null ? 0 : this.getEventTypeName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateModelRequest clone() {
        return (CreateModelRequest)super.clone();
    }
}

