/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.EntryDescription;
import com.amazonaws.services.fms.model.EntryViolationReason;
import com.amazonaws.services.fms.model.transform.EntryViolationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EntryViolation
implements Serializable,
Cloneable,
StructuredPojo {
    private EntryDescription expectedEntry;
    private String expectedEvaluationOrder;
    private String actualEvaluationOrder;
    private EntryDescription entryAtExpectedEvaluationOrder;
    private List<EntryDescription> entriesWithConflicts;
    private List<String> entryViolationReasons;

    public void setExpectedEntry(EntryDescription expectedEntry) {
        this.expectedEntry = expectedEntry;
    }

    public EntryDescription getExpectedEntry() {
        return this.expectedEntry;
    }

    public EntryViolation withExpectedEntry(EntryDescription expectedEntry) {
        this.setExpectedEntry(expectedEntry);
        return this;
    }

    public void setExpectedEvaluationOrder(String expectedEvaluationOrder) {
        this.expectedEvaluationOrder = expectedEvaluationOrder;
    }

    public String getExpectedEvaluationOrder() {
        return this.expectedEvaluationOrder;
    }

    public EntryViolation withExpectedEvaluationOrder(String expectedEvaluationOrder) {
        this.setExpectedEvaluationOrder(expectedEvaluationOrder);
        return this;
    }

    public void setActualEvaluationOrder(String actualEvaluationOrder) {
        this.actualEvaluationOrder = actualEvaluationOrder;
    }

    public String getActualEvaluationOrder() {
        return this.actualEvaluationOrder;
    }

    public EntryViolation withActualEvaluationOrder(String actualEvaluationOrder) {
        this.setActualEvaluationOrder(actualEvaluationOrder);
        return this;
    }

    public void setEntryAtExpectedEvaluationOrder(EntryDescription entryAtExpectedEvaluationOrder) {
        this.entryAtExpectedEvaluationOrder = entryAtExpectedEvaluationOrder;
    }

    public EntryDescription getEntryAtExpectedEvaluationOrder() {
        return this.entryAtExpectedEvaluationOrder;
    }

    public EntryViolation withEntryAtExpectedEvaluationOrder(EntryDescription entryAtExpectedEvaluationOrder) {
        this.setEntryAtExpectedEvaluationOrder(entryAtExpectedEvaluationOrder);
        return this;
    }

    public List<EntryDescription> getEntriesWithConflicts() {
        return this.entriesWithConflicts;
    }

    public void setEntriesWithConflicts(Collection<EntryDescription> entriesWithConflicts) {
        if (entriesWithConflicts == null) {
            this.entriesWithConflicts = null;
            return;
        }
        this.entriesWithConflicts = new ArrayList<EntryDescription>(entriesWithConflicts);
    }

    public EntryViolation withEntriesWithConflicts(EntryDescription ... entriesWithConflicts) {
        if (this.entriesWithConflicts == null) {
            this.setEntriesWithConflicts(new ArrayList<EntryDescription>(entriesWithConflicts.length));
        }
        for (EntryDescription ele : entriesWithConflicts) {
            this.entriesWithConflicts.add(ele);
        }
        return this;
    }

    public EntryViolation withEntriesWithConflicts(Collection<EntryDescription> entriesWithConflicts) {
        this.setEntriesWithConflicts(entriesWithConflicts);
        return this;
    }

    public List<String> getEntryViolationReasons() {
        return this.entryViolationReasons;
    }

    public void setEntryViolationReasons(Collection<String> entryViolationReasons) {
        if (entryViolationReasons == null) {
            this.entryViolationReasons = null;
            return;
        }
        this.entryViolationReasons = new ArrayList<String>(entryViolationReasons);
    }

    public EntryViolation withEntryViolationReasons(String ... entryViolationReasons) {
        if (this.entryViolationReasons == null) {
            this.setEntryViolationReasons(new ArrayList<String>(entryViolationReasons.length));
        }
        for (String ele : entryViolationReasons) {
            this.entryViolationReasons.add(ele);
        }
        return this;
    }

    public EntryViolation withEntryViolationReasons(Collection<String> entryViolationReasons) {
        this.setEntryViolationReasons(entryViolationReasons);
        return this;
    }

    public EntryViolation withEntryViolationReasons(EntryViolationReason ... entryViolationReasons) {
        ArrayList<String> entryViolationReasonsCopy = new ArrayList<String>(entryViolationReasons.length);
        for (EntryViolationReason value : entryViolationReasons) {
            entryViolationReasonsCopy.add(value.toString());
        }
        if (this.getEntryViolationReasons() == null) {
            this.setEntryViolationReasons(entryViolationReasonsCopy);
        } else {
            this.getEntryViolationReasons().addAll(entryViolationReasonsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExpectedEntry() != null) {
            sb.append("ExpectedEntry: ").append(this.getExpectedEntry()).append(",");
        }
        if (this.getExpectedEvaluationOrder() != null) {
            sb.append("ExpectedEvaluationOrder: ").append(this.getExpectedEvaluationOrder()).append(",");
        }
        if (this.getActualEvaluationOrder() != null) {
            sb.append("ActualEvaluationOrder: ").append(this.getActualEvaluationOrder()).append(",");
        }
        if (this.getEntryAtExpectedEvaluationOrder() != null) {
            sb.append("EntryAtExpectedEvaluationOrder: ").append(this.getEntryAtExpectedEvaluationOrder()).append(",");
        }
        if (this.getEntriesWithConflicts() != null) {
            sb.append("EntriesWithConflicts: ").append(this.getEntriesWithConflicts()).append(",");
        }
        if (this.getEntryViolationReasons() != null) {
            sb.append("EntryViolationReasons: ").append(this.getEntryViolationReasons());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntryViolation)) {
            return false;
        }
        EntryViolation other = (EntryViolation)obj;
        if (other.getExpectedEntry() == null ^ this.getExpectedEntry() == null) {
            return false;
        }
        if (other.getExpectedEntry() != null && !other.getExpectedEntry().equals(this.getExpectedEntry())) {
            return false;
        }
        if (other.getExpectedEvaluationOrder() == null ^ this.getExpectedEvaluationOrder() == null) {
            return false;
        }
        if (other.getExpectedEvaluationOrder() != null && !other.getExpectedEvaluationOrder().equals(this.getExpectedEvaluationOrder())) {
            return false;
        }
        if (other.getActualEvaluationOrder() == null ^ this.getActualEvaluationOrder() == null) {
            return false;
        }
        if (other.getActualEvaluationOrder() != null && !other.getActualEvaluationOrder().equals(this.getActualEvaluationOrder())) {
            return false;
        }
        if (other.getEntryAtExpectedEvaluationOrder() == null ^ this.getEntryAtExpectedEvaluationOrder() == null) {
            return false;
        }
        if (other.getEntryAtExpectedEvaluationOrder() != null && !other.getEntryAtExpectedEvaluationOrder().equals(this.getEntryAtExpectedEvaluationOrder())) {
            return false;
        }
        if (other.getEntriesWithConflicts() == null ^ this.getEntriesWithConflicts() == null) {
            return false;
        }
        if (other.getEntriesWithConflicts() != null && !other.getEntriesWithConflicts().equals(this.getEntriesWithConflicts())) {
            return false;
        }
        if (other.getEntryViolationReasons() == null ^ this.getEntryViolationReasons() == null) {
            return false;
        }
        return other.getEntryViolationReasons() == null || other.getEntryViolationReasons().equals(this.getEntryViolationReasons());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExpectedEntry() == null ? 0 : this.getExpectedEntry().hashCode());
        hashCode = 31 * hashCode + (this.getExpectedEvaluationOrder() == null ? 0 : this.getExpectedEvaluationOrder().hashCode());
        hashCode = 31 * hashCode + (this.getActualEvaluationOrder() == null ? 0 : this.getActualEvaluationOrder().hashCode());
        hashCode = 31 * hashCode + (this.getEntryAtExpectedEvaluationOrder() == null ? 0 : this.getEntryAtExpectedEvaluationOrder().hashCode());
        hashCode = 31 * hashCode + (this.getEntriesWithConflicts() == null ? 0 : this.getEntriesWithConflicts().hashCode());
        hashCode = 31 * hashCode + (this.getEntryViolationReasons() == null ? 0 : this.getEntryViolationReasons().hashCode());
        return hashCode;
    }

    public EntryViolation clone() {
        try {
            return (EntryViolation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntryViolationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

