/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.transform.AccountScopeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AccountScope
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> accounts;
    private Boolean allAccountsEnabled;
    private Boolean excludeSpecifiedAccounts;

    public List<String> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Collection<String> accounts) {
        if (accounts == null) {
            this.accounts = null;
            return;
        }
        this.accounts = new ArrayList<String>(accounts);
    }

    public AccountScope withAccounts(String ... accounts) {
        if (this.accounts == null) {
            this.setAccounts(new ArrayList<String>(accounts.length));
        }
        for (String ele : accounts) {
            this.accounts.add(ele);
        }
        return this;
    }

    public AccountScope withAccounts(Collection<String> accounts) {
        this.setAccounts(accounts);
        return this;
    }

    public void setAllAccountsEnabled(Boolean allAccountsEnabled) {
        this.allAccountsEnabled = allAccountsEnabled;
    }

    public Boolean getAllAccountsEnabled() {
        return this.allAccountsEnabled;
    }

    public AccountScope withAllAccountsEnabled(Boolean allAccountsEnabled) {
        this.setAllAccountsEnabled(allAccountsEnabled);
        return this;
    }

    public Boolean isAllAccountsEnabled() {
        return this.allAccountsEnabled;
    }

    public void setExcludeSpecifiedAccounts(Boolean excludeSpecifiedAccounts) {
        this.excludeSpecifiedAccounts = excludeSpecifiedAccounts;
    }

    public Boolean getExcludeSpecifiedAccounts() {
        return this.excludeSpecifiedAccounts;
    }

    public AccountScope withExcludeSpecifiedAccounts(Boolean excludeSpecifiedAccounts) {
        this.setExcludeSpecifiedAccounts(excludeSpecifiedAccounts);
        return this;
    }

    public Boolean isExcludeSpecifiedAccounts() {
        return this.excludeSpecifiedAccounts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccounts() != null) {
            sb.append("Accounts: ").append(this.getAccounts()).append(",");
        }
        if (this.getAllAccountsEnabled() != null) {
            sb.append("AllAccountsEnabled: ").append(this.getAllAccountsEnabled()).append(",");
        }
        if (this.getExcludeSpecifiedAccounts() != null) {
            sb.append("ExcludeSpecifiedAccounts: ").append(this.getExcludeSpecifiedAccounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountScope)) {
            return false;
        }
        AccountScope other = (AccountScope)obj;
        if (other.getAccounts() == null ^ this.getAccounts() == null) {
            return false;
        }
        if (other.getAccounts() != null && !other.getAccounts().equals(this.getAccounts())) {
            return false;
        }
        if (other.getAllAccountsEnabled() == null ^ this.getAllAccountsEnabled() == null) {
            return false;
        }
        if (other.getAllAccountsEnabled() != null && !other.getAllAccountsEnabled().equals(this.getAllAccountsEnabled())) {
            return false;
        }
        if (other.getExcludeSpecifiedAccounts() == null ^ this.getExcludeSpecifiedAccounts() == null) {
            return false;
        }
        return other.getExcludeSpecifiedAccounts() == null || other.getExcludeSpecifiedAccounts().equals(this.getExcludeSpecifiedAccounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccounts() == null ? 0 : this.getAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getAllAccountsEnabled() == null ? 0 : this.getAllAccountsEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeSpecifiedAccounts() == null ? 0 : this.getExcludeSpecifiedAccounts().hashCode());
        return hashCode;
    }

    public AccountScope clone() {
        try {
            return (AccountScope)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountScopeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

