/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.fms.model.FailedItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchDisassociateResourceResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String resourceSetIdentifier;
    private List<FailedItem> failedItems;

    public void setResourceSetIdentifier(String resourceSetIdentifier) {
        this.resourceSetIdentifier = resourceSetIdentifier;
    }

    public String getResourceSetIdentifier() {
        return this.resourceSetIdentifier;
    }

    public BatchDisassociateResourceResult withResourceSetIdentifier(String resourceSetIdentifier) {
        this.setResourceSetIdentifier(resourceSetIdentifier);
        return this;
    }

    public List<FailedItem> getFailedItems() {
        return this.failedItems;
    }

    public void setFailedItems(Collection<FailedItem> failedItems) {
        if (failedItems == null) {
            this.failedItems = null;
            return;
        }
        this.failedItems = new ArrayList<FailedItem>(failedItems);
    }

    public BatchDisassociateResourceResult withFailedItems(FailedItem ... failedItems) {
        if (this.failedItems == null) {
            this.setFailedItems(new ArrayList<FailedItem>(failedItems.length));
        }
        for (FailedItem ele : failedItems) {
            this.failedItems.add(ele);
        }
        return this;
    }

    public BatchDisassociateResourceResult withFailedItems(Collection<FailedItem> failedItems) {
        this.setFailedItems(failedItems);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceSetIdentifier() != null) {
            sb.append("ResourceSetIdentifier: ").append(this.getResourceSetIdentifier()).append(",");
        }
        if (this.getFailedItems() != null) {
            sb.append("FailedItems: ").append(this.getFailedItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateResourceResult)) {
            return false;
        }
        BatchDisassociateResourceResult other = (BatchDisassociateResourceResult)obj;
        if (other.getResourceSetIdentifier() == null ^ this.getResourceSetIdentifier() == null) {
            return false;
        }
        if (other.getResourceSetIdentifier() != null && !other.getResourceSetIdentifier().equals(this.getResourceSetIdentifier())) {
            return false;
        }
        if (other.getFailedItems() == null ^ this.getFailedItems() == null) {
            return false;
        }
        return other.getFailedItems() == null || other.getFailedItems().equals(this.getFailedItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceSetIdentifier() == null ? 0 : this.getResourceSetIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getFailedItems() == null ? 0 : this.getFailedItems().hashCode());
        return hashCode;
    }

    public BatchDisassociateResourceResult clone() {
        try {
            return (BatchDisassociateResourceResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

