/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.fis.model.ExperimentSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListExperimentsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ExperimentSummary> experiments;
    private String nextToken;

    public List<ExperimentSummary> getExperiments() {
        return this.experiments;
    }

    public void setExperiments(Collection<ExperimentSummary> experiments) {
        if (experiments == null) {
            this.experiments = null;
            return;
        }
        this.experiments = new ArrayList<ExperimentSummary>(experiments);
    }

    public ListExperimentsResult withExperiments(ExperimentSummary ... experiments) {
        if (this.experiments == null) {
            this.setExperiments(new ArrayList<ExperimentSummary>(experiments.length));
        }
        for (ExperimentSummary ele : experiments) {
            this.experiments.add(ele);
        }
        return this;
    }

    public ListExperimentsResult withExperiments(Collection<ExperimentSummary> experiments) {
        this.setExperiments(experiments);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListExperimentsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExperiments() != null) {
            sb.append("Experiments: ").append(this.getExperiments()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperimentsResult)) {
            return false;
        }
        ListExperimentsResult other = (ListExperimentsResult)obj;
        if (other.getExperiments() == null ^ this.getExperiments() == null) {
            return false;
        }
        if (other.getExperiments() != null && !other.getExperiments().equals(this.getExperiments())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExperiments() == null ? 0 : this.getExperiments().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListExperimentsResult clone() {
        try {
            return (ListExperimentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

