/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fis.model.ExperimentTemplateTargetInputFilter;
import com.amazonaws.services.fis.model.transform.UpdateExperimentTemplateTargetInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateExperimentTemplateTargetInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceType;
    private List<String> resourceArns;
    private Map<String, String> resourceTags;
    private List<ExperimentTemplateTargetInputFilter> filters;
    private String selectionMode;
    private Map<String, String> parameters;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public UpdateExperimentTemplateTargetInput withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public List<String> getResourceArns() {
        return this.resourceArns;
    }

    public void setResourceArns(Collection<String> resourceArns) {
        if (resourceArns == null) {
            this.resourceArns = null;
            return;
        }
        this.resourceArns = new ArrayList<String>(resourceArns);
    }

    public UpdateExperimentTemplateTargetInput withResourceArns(String ... resourceArns) {
        if (this.resourceArns == null) {
            this.setResourceArns(new ArrayList<String>(resourceArns.length));
        }
        for (String ele : resourceArns) {
            this.resourceArns.add(ele);
        }
        return this;
    }

    public UpdateExperimentTemplateTargetInput withResourceArns(Collection<String> resourceArns) {
        this.setResourceArns(resourceArns);
        return this;
    }

    public Map<String, String> getResourceTags() {
        return this.resourceTags;
    }

    public void setResourceTags(Map<String, String> resourceTags) {
        this.resourceTags = resourceTags;
    }

    public UpdateExperimentTemplateTargetInput withResourceTags(Map<String, String> resourceTags) {
        this.setResourceTags(resourceTags);
        return this;
    }

    public UpdateExperimentTemplateTargetInput addResourceTagsEntry(String key, String value) {
        if (null == this.resourceTags) {
            this.resourceTags = new HashMap<String, String>();
        }
        if (this.resourceTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.resourceTags.put(key, value);
        return this;
    }

    public UpdateExperimentTemplateTargetInput clearResourceTagsEntries() {
        this.resourceTags = null;
        return this;
    }

    public List<ExperimentTemplateTargetInputFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<ExperimentTemplateTargetInputFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<ExperimentTemplateTargetInputFilter>(filters);
    }

    public UpdateExperimentTemplateTargetInput withFilters(ExperimentTemplateTargetInputFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<ExperimentTemplateTargetInputFilter>(filters.length));
        }
        for (ExperimentTemplateTargetInputFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public UpdateExperimentTemplateTargetInput withFilters(Collection<ExperimentTemplateTargetInputFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setSelectionMode(String selectionMode) {
        this.selectionMode = selectionMode;
    }

    public String getSelectionMode() {
        return this.selectionMode;
    }

    public UpdateExperimentTemplateTargetInput withSelectionMode(String selectionMode) {
        this.setSelectionMode(selectionMode);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public UpdateExperimentTemplateTargetInput withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public UpdateExperimentTemplateTargetInput addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public UpdateExperimentTemplateTargetInput clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceArns() != null) {
            sb.append("ResourceArns: ").append(this.getResourceArns()).append(",");
        }
        if (this.getResourceTags() != null) {
            sb.append("ResourceTags: ").append(this.getResourceTags()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getSelectionMode() != null) {
            sb.append("SelectionMode: ").append(this.getSelectionMode()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExperimentTemplateTargetInput)) {
            return false;
        }
        UpdateExperimentTemplateTargetInput other = (UpdateExperimentTemplateTargetInput)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceArns() == null ^ this.getResourceArns() == null) {
            return false;
        }
        if (other.getResourceArns() != null && !other.getResourceArns().equals(this.getResourceArns())) {
            return false;
        }
        if (other.getResourceTags() == null ^ this.getResourceTags() == null) {
            return false;
        }
        if (other.getResourceTags() != null && !other.getResourceTags().equals(this.getResourceTags())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getSelectionMode() == null ^ this.getSelectionMode() == null) {
            return false;
        }
        if (other.getSelectionMode() != null && !other.getSelectionMode().equals(this.getSelectionMode())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArns() == null ? 0 : this.getResourceArns().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTags() == null ? 0 : this.getResourceTags().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getSelectionMode() == null ? 0 : this.getSelectionMode().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public UpdateExperimentTemplateTargetInput clone() {
        try {
            return (UpdateExperimentTemplateTargetInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpdateExperimentTemplateTargetInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

