/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fis.model.transform.ResolvedTargetMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ResolvedTarget
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceType;
    private String targetName;
    private Map<String, String> targetInformation;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResolvedTarget withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public ResolvedTarget withTargetName(String targetName) {
        this.setTargetName(targetName);
        return this;
    }

    public Map<String, String> getTargetInformation() {
        return this.targetInformation;
    }

    public void setTargetInformation(Map<String, String> targetInformation) {
        this.targetInformation = targetInformation;
    }

    public ResolvedTarget withTargetInformation(Map<String, String> targetInformation) {
        this.setTargetInformation(targetInformation);
        return this;
    }

    public ResolvedTarget addTargetInformationEntry(String key, String value) {
        if (null == this.targetInformation) {
            this.targetInformation = new HashMap<String, String>();
        }
        if (this.targetInformation.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.targetInformation.put(key, value);
        return this;
    }

    public ResolvedTarget clearTargetInformationEntries() {
        this.targetInformation = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getTargetName() != null) {
            sb.append("TargetName: ").append(this.getTargetName()).append(",");
        }
        if (this.getTargetInformation() != null) {
            sb.append("TargetInformation: ").append(this.getTargetInformation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedTarget)) {
            return false;
        }
        ResolvedTarget other = (ResolvedTarget)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getTargetName() == null ^ this.getTargetName() == null) {
            return false;
        }
        if (other.getTargetName() != null && !other.getTargetName().equals(this.getTargetName())) {
            return false;
        }
        if (other.getTargetInformation() == null ^ this.getTargetInformation() == null) {
            return false;
        }
        return other.getTargetInformation() == null || other.getTargetInformation().equals(this.getTargetInformation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getTargetName() == null ? 0 : this.getTargetName().hashCode());
        hashCode = 31 * hashCode + (this.getTargetInformation() == null ? 0 : this.getTargetInformation().hashCode());
        return hashCode;
    }

    public ResolvedTarget clone() {
        try {
            return (ResolvedTarget)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResolvedTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

