/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.fis.model.CreateExperimentTemplateActionInput;
import com.amazonaws.services.fis.model.CreateExperimentTemplateLogConfigurationInput;
import com.amazonaws.services.fis.model.CreateExperimentTemplateStopConditionInput;
import com.amazonaws.services.fis.model.CreateExperimentTemplateTargetInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateExperimentTemplateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String description;
    private List<CreateExperimentTemplateStopConditionInput> stopConditions;
    private Map<String, CreateExperimentTemplateTargetInput> targets;
    private Map<String, CreateExperimentTemplateActionInput> actions;
    private String roleArn;
    private Map<String, String> tags;
    private CreateExperimentTemplateLogConfigurationInput logConfiguration;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateExperimentTemplateRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateExperimentTemplateRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<CreateExperimentTemplateStopConditionInput> getStopConditions() {
        return this.stopConditions;
    }

    public void setStopConditions(Collection<CreateExperimentTemplateStopConditionInput> stopConditions) {
        if (stopConditions == null) {
            this.stopConditions = null;
            return;
        }
        this.stopConditions = new ArrayList<CreateExperimentTemplateStopConditionInput>(stopConditions);
    }

    public CreateExperimentTemplateRequest withStopConditions(CreateExperimentTemplateStopConditionInput ... stopConditions) {
        if (this.stopConditions == null) {
            this.setStopConditions(new ArrayList<CreateExperimentTemplateStopConditionInput>(stopConditions.length));
        }
        for (CreateExperimentTemplateStopConditionInput ele : stopConditions) {
            this.stopConditions.add(ele);
        }
        return this;
    }

    public CreateExperimentTemplateRequest withStopConditions(Collection<CreateExperimentTemplateStopConditionInput> stopConditions) {
        this.setStopConditions(stopConditions);
        return this;
    }

    public Map<String, CreateExperimentTemplateTargetInput> getTargets() {
        return this.targets;
    }

    public void setTargets(Map<String, CreateExperimentTemplateTargetInput> targets) {
        this.targets = targets;
    }

    public CreateExperimentTemplateRequest withTargets(Map<String, CreateExperimentTemplateTargetInput> targets) {
        this.setTargets(targets);
        return this;
    }

    public CreateExperimentTemplateRequest addTargetsEntry(String key, CreateExperimentTemplateTargetInput value) {
        if (null == this.targets) {
            this.targets = new HashMap<String, CreateExperimentTemplateTargetInput>();
        }
        if (this.targets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.targets.put(key, value);
        return this;
    }

    public CreateExperimentTemplateRequest clearTargetsEntries() {
        this.targets = null;
        return this;
    }

    public Map<String, CreateExperimentTemplateActionInput> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, CreateExperimentTemplateActionInput> actions) {
        this.actions = actions;
    }

    public CreateExperimentTemplateRequest withActions(Map<String, CreateExperimentTemplateActionInput> actions) {
        this.setActions(actions);
        return this;
    }

    public CreateExperimentTemplateRequest addActionsEntry(String key, CreateExperimentTemplateActionInput value) {
        if (null == this.actions) {
            this.actions = new HashMap<String, CreateExperimentTemplateActionInput>();
        }
        if (this.actions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.actions.put(key, value);
        return this;
    }

    public CreateExperimentTemplateRequest clearActionsEntries() {
        this.actions = null;
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateExperimentTemplateRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateExperimentTemplateRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateExperimentTemplateRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateExperimentTemplateRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setLogConfiguration(CreateExperimentTemplateLogConfigurationInput logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public CreateExperimentTemplateLogConfigurationInput getLogConfiguration() {
        return this.logConfiguration;
    }

    public CreateExperimentTemplateRequest withLogConfiguration(CreateExperimentTemplateLogConfigurationInput logConfiguration) {
        this.setLogConfiguration(logConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getStopConditions() != null) {
            sb.append("StopConditions: ").append(this.getStopConditions()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getLogConfiguration() != null) {
            sb.append("LogConfiguration: ").append(this.getLogConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExperimentTemplateRequest)) {
            return false;
        }
        CreateExperimentTemplateRequest other = (CreateExperimentTemplateRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getStopConditions() == null ^ this.getStopConditions() == null) {
            return false;
        }
        if (other.getStopConditions() != null && !other.getStopConditions().equals(this.getStopConditions())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getLogConfiguration() == null ^ this.getLogConfiguration() == null) {
            return false;
        }
        return other.getLogConfiguration() == null || other.getLogConfiguration().equals(this.getLogConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getStopConditions() == null ? 0 : this.getStopConditions().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getLogConfiguration() == null ? 0 : this.getLogConfiguration().hashCode());
        return hashCode;
    }

    public CreateExperimentTemplateRequest clone() {
        return (CreateExperimentTemplateRequest)super.clone();
    }
}

