/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.fis.AWSFIS;
import com.amazonaws.services.fis.AWSFISClientBuilder;
import com.amazonaws.services.fis.model.AWSFISException;
import com.amazonaws.services.fis.model.CreateExperimentTemplateRequest;
import com.amazonaws.services.fis.model.CreateExperimentTemplateResult;
import com.amazonaws.services.fis.model.DeleteExperimentTemplateRequest;
import com.amazonaws.services.fis.model.DeleteExperimentTemplateResult;
import com.amazonaws.services.fis.model.GetActionRequest;
import com.amazonaws.services.fis.model.GetActionResult;
import com.amazonaws.services.fis.model.GetExperimentRequest;
import com.amazonaws.services.fis.model.GetExperimentResult;
import com.amazonaws.services.fis.model.GetExperimentTemplateRequest;
import com.amazonaws.services.fis.model.GetExperimentTemplateResult;
import com.amazonaws.services.fis.model.GetTargetResourceTypeRequest;
import com.amazonaws.services.fis.model.GetTargetResourceTypeResult;
import com.amazonaws.services.fis.model.ListActionsRequest;
import com.amazonaws.services.fis.model.ListActionsResult;
import com.amazonaws.services.fis.model.ListExperimentTemplatesRequest;
import com.amazonaws.services.fis.model.ListExperimentTemplatesResult;
import com.amazonaws.services.fis.model.ListExperimentsRequest;
import com.amazonaws.services.fis.model.ListExperimentsResult;
import com.amazonaws.services.fis.model.ListTagsForResourceRequest;
import com.amazonaws.services.fis.model.ListTagsForResourceResult;
import com.amazonaws.services.fis.model.ListTargetResourceTypesRequest;
import com.amazonaws.services.fis.model.ListTargetResourceTypesResult;
import com.amazonaws.services.fis.model.StartExperimentRequest;
import com.amazonaws.services.fis.model.StartExperimentResult;
import com.amazonaws.services.fis.model.StopExperimentRequest;
import com.amazonaws.services.fis.model.StopExperimentResult;
import com.amazonaws.services.fis.model.TagResourceRequest;
import com.amazonaws.services.fis.model.TagResourceResult;
import com.amazonaws.services.fis.model.UntagResourceRequest;
import com.amazonaws.services.fis.model.UntagResourceResult;
import com.amazonaws.services.fis.model.UpdateExperimentTemplateRequest;
import com.amazonaws.services.fis.model.UpdateExperimentTemplateResult;
import com.amazonaws.services.fis.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.fis.model.transform.CreateExperimentTemplateRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.CreateExperimentTemplateResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.DeleteExperimentTemplateRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.DeleteExperimentTemplateResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.GetActionRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.GetActionResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.GetExperimentRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.GetExperimentResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.GetExperimentTemplateRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.GetExperimentTemplateResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.GetTargetResourceTypeRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.GetTargetResourceTypeResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.ListActionsRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.ListActionsResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.ListExperimentTemplatesRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.ListExperimentTemplatesResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.ListExperimentsRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.ListExperimentsResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.ListTargetResourceTypesRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.ListTargetResourceTypesResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.fis.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.fis.model.transform.StartExperimentRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.StartExperimentResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.StopExperimentRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.StopExperimentResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.UpdateExperimentTemplateRequestProtocolMarshaller;
import com.amazonaws.services.fis.model.transform.UpdateExperimentTemplateResultJsonUnmarshaller;
import com.amazonaws.services.fis.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSFISClient
extends AmazonWebServiceClient
implements AWSFIS {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSFIS.class);
    private static final String DEFAULT_SIGNING_NAME = "fis";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSFISException.class));

    public static AWSFISClientBuilder builder() {
        return AWSFISClientBuilder.standard();
    }

    AWSFISClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSFISClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("fis.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/fis/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/fis/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateExperimentTemplateResult createExperimentTemplate(CreateExperimentTemplateRequest request) {
        request = (CreateExperimentTemplateRequest)this.beforeClientExecution(request);
        return this.executeCreateExperimentTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateExperimentTemplateResult executeCreateExperimentTemplate(CreateExperimentTemplateRequest createExperimentTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createExperimentTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateExperimentTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateExperimentTemplateRequestProtocolMarshaller(protocolFactory).marshall((CreateExperimentTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)createExperimentTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateExperimentTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateExperimentTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateExperimentTemplateResult createExperimentTemplateResult = (CreateExperimentTemplateResult)response.getAwsResponse();
            return createExperimentTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteExperimentTemplateResult deleteExperimentTemplate(DeleteExperimentTemplateRequest request) {
        request = (DeleteExperimentTemplateRequest)this.beforeClientExecution(request);
        return this.executeDeleteExperimentTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteExperimentTemplateResult executeDeleteExperimentTemplate(DeleteExperimentTemplateRequest deleteExperimentTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteExperimentTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteExperimentTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteExperimentTemplateRequestProtocolMarshaller(protocolFactory).marshall((DeleteExperimentTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteExperimentTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteExperimentTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteExperimentTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteExperimentTemplateResult deleteExperimentTemplateResult = (DeleteExperimentTemplateResult)response.getAwsResponse();
            return deleteExperimentTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetActionResult getAction(GetActionRequest request) {
        request = (GetActionRequest)this.beforeClientExecution(request);
        return this.executeGetAction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetActionResult executeGetAction(GetActionRequest getActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetActionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetActionRequestProtocolMarshaller(protocolFactory).marshall((GetActionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getActionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetActionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetActionResult getActionResult = (GetActionResult)response.getAwsResponse();
            return getActionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetExperimentResult getExperiment(GetExperimentRequest request) {
        request = (GetExperimentRequest)this.beforeClientExecution(request);
        return this.executeGetExperiment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetExperimentResult executeGetExperiment(GetExperimentRequest getExperimentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getExperimentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetExperimentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetExperimentRequestProtocolMarshaller(protocolFactory).marshall((GetExperimentRequest)super.beforeMarshalling((AmazonWebServiceRequest)getExperimentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetExperiment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetExperimentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetExperimentResult getExperimentResult = (GetExperimentResult)response.getAwsResponse();
            return getExperimentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetExperimentTemplateResult getExperimentTemplate(GetExperimentTemplateRequest request) {
        request = (GetExperimentTemplateRequest)this.beforeClientExecution(request);
        return this.executeGetExperimentTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetExperimentTemplateResult executeGetExperimentTemplate(GetExperimentTemplateRequest getExperimentTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getExperimentTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetExperimentTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetExperimentTemplateRequestProtocolMarshaller(protocolFactory).marshall((GetExperimentTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)getExperimentTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetExperimentTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetExperimentTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetExperimentTemplateResult getExperimentTemplateResult = (GetExperimentTemplateResult)response.getAwsResponse();
            return getExperimentTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTargetResourceTypeResult getTargetResourceType(GetTargetResourceTypeRequest request) {
        request = (GetTargetResourceTypeRequest)this.beforeClientExecution(request);
        return this.executeGetTargetResourceType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTargetResourceTypeResult executeGetTargetResourceType(GetTargetResourceTypeRequest getTargetResourceTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTargetResourceTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTargetResourceTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTargetResourceTypeRequestProtocolMarshaller(protocolFactory).marshall((GetTargetResourceTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTargetResourceTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTargetResourceType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTargetResourceTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTargetResourceTypeResult getTargetResourceTypeResult = (GetTargetResourceTypeResult)response.getAwsResponse();
            return getTargetResourceTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListActionsResult listActions(ListActionsRequest request) {
        request = (ListActionsRequest)this.beforeClientExecution(request);
        return this.executeListActions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListActionsResult executeListActions(ListActionsRequest listActionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listActionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListActionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListActionsRequestProtocolMarshaller(protocolFactory).marshall((ListActionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listActionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListActions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListActionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListActionsResult listActionsResult = (ListActionsResult)response.getAwsResponse();
            return listActionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListExperimentTemplatesResult listExperimentTemplates(ListExperimentTemplatesRequest request) {
        request = (ListExperimentTemplatesRequest)this.beforeClientExecution(request);
        return this.executeListExperimentTemplates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListExperimentTemplatesResult executeListExperimentTemplates(ListExperimentTemplatesRequest listExperimentTemplatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listExperimentTemplatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListExperimentTemplatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListExperimentTemplatesRequestProtocolMarshaller(protocolFactory).marshall((ListExperimentTemplatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listExperimentTemplatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListExperimentTemplates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListExperimentTemplatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListExperimentTemplatesResult listExperimentTemplatesResult = (ListExperimentTemplatesResult)response.getAwsResponse();
            return listExperimentTemplatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListExperimentsResult listExperiments(ListExperimentsRequest request) {
        request = (ListExperimentsRequest)this.beforeClientExecution(request);
        return this.executeListExperiments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListExperimentsResult executeListExperiments(ListExperimentsRequest listExperimentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listExperimentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListExperimentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListExperimentsRequestProtocolMarshaller(protocolFactory).marshall((ListExperimentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listExperimentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListExperiments");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListExperimentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListExperimentsResult listExperimentsResult = (ListExperimentsResult)response.getAwsResponse();
            return listExperimentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTargetResourceTypesResult listTargetResourceTypes(ListTargetResourceTypesRequest request) {
        request = (ListTargetResourceTypesRequest)this.beforeClientExecution(request);
        return this.executeListTargetResourceTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTargetResourceTypesResult executeListTargetResourceTypes(ListTargetResourceTypesRequest listTargetResourceTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTargetResourceTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTargetResourceTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTargetResourceTypesRequestProtocolMarshaller(protocolFactory).marshall((ListTargetResourceTypesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTargetResourceTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTargetResourceTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTargetResourceTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTargetResourceTypesResult listTargetResourceTypesResult = (ListTargetResourceTypesResult)response.getAwsResponse();
            return listTargetResourceTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartExperimentResult startExperiment(StartExperimentRequest request) {
        request = (StartExperimentRequest)this.beforeClientExecution(request);
        return this.executeStartExperiment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartExperimentResult executeStartExperiment(StartExperimentRequest startExperimentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startExperimentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartExperimentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartExperimentRequestProtocolMarshaller(protocolFactory).marshall((StartExperimentRequest)super.beforeMarshalling((AmazonWebServiceRequest)startExperimentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartExperiment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartExperimentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartExperimentResult startExperimentResult = (StartExperimentResult)response.getAwsResponse();
            return startExperimentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopExperimentResult stopExperiment(StopExperimentRequest request) {
        request = (StopExperimentRequest)this.beforeClientExecution(request);
        return this.executeStopExperiment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopExperimentResult executeStopExperiment(StopExperimentRequest stopExperimentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopExperimentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopExperimentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopExperimentRequestProtocolMarshaller(protocolFactory).marshall((StopExperimentRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopExperimentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopExperiment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopExperimentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopExperimentResult stopExperimentResult = (StopExperimentResult)response.getAwsResponse();
            return stopExperimentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateExperimentTemplateResult updateExperimentTemplate(UpdateExperimentTemplateRequest request) {
        request = (UpdateExperimentTemplateRequest)this.beforeClientExecution(request);
        return this.executeUpdateExperimentTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateExperimentTemplateResult executeUpdateExperimentTemplate(UpdateExperimentTemplateRequest updateExperimentTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateExperimentTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateExperimentTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateExperimentTemplateRequestProtocolMarshaller(protocolFactory).marshall((UpdateExperimentTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateExperimentTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateExperimentTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateExperimentTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateExperimentTemplateResult updateExperimentTemplateResult = (UpdateExperimentTemplateResult)response.getAwsResponse();
            return updateExperimentTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

