/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspacedata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.finspacedata.model.ApplicationPermission;
import com.amazonaws.services.finspacedata.model.transform.PermissionGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PermissionGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String permissionGroupId;
    private String name;
    private String description;
    private List<String> applicationPermissions;
    private Long createTime;
    private Long lastModifiedTime;

    public void setPermissionGroupId(String permissionGroupId) {
        this.permissionGroupId = permissionGroupId;
    }

    public String getPermissionGroupId() {
        return this.permissionGroupId;
    }

    public PermissionGroup withPermissionGroupId(String permissionGroupId) {
        this.setPermissionGroupId(permissionGroupId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PermissionGroup withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public PermissionGroup withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getApplicationPermissions() {
        return this.applicationPermissions;
    }

    public void setApplicationPermissions(Collection<String> applicationPermissions) {
        if (applicationPermissions == null) {
            this.applicationPermissions = null;
            return;
        }
        this.applicationPermissions = new ArrayList<String>(applicationPermissions);
    }

    public PermissionGroup withApplicationPermissions(String ... applicationPermissions) {
        if (this.applicationPermissions == null) {
            this.setApplicationPermissions(new ArrayList<String>(applicationPermissions.length));
        }
        for (String ele : applicationPermissions) {
            this.applicationPermissions.add(ele);
        }
        return this;
    }

    public PermissionGroup withApplicationPermissions(Collection<String> applicationPermissions) {
        this.setApplicationPermissions(applicationPermissions);
        return this;
    }

    public PermissionGroup withApplicationPermissions(ApplicationPermission ... applicationPermissions) {
        ArrayList<String> applicationPermissionsCopy = new ArrayList<String>(applicationPermissions.length);
        for (ApplicationPermission value : applicationPermissions) {
            applicationPermissionsCopy.add(value.toString());
        }
        if (this.getApplicationPermissions() == null) {
            this.setApplicationPermissions(applicationPermissionsCopy);
        } else {
            this.getApplicationPermissions().addAll(applicationPermissionsCopy);
        }
        return this;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public PermissionGroup withCreateTime(Long createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public void setLastModifiedTime(Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public PermissionGroup withLastModifiedTime(Long lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPermissionGroupId() != null) {
            sb.append("PermissionGroupId: ").append(this.getPermissionGroupId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getApplicationPermissions() != null) {
            sb.append("ApplicationPermissions: ").append(this.getApplicationPermissions()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionGroup)) {
            return false;
        }
        PermissionGroup other = (PermissionGroup)obj;
        if (other.getPermissionGroupId() == null ^ this.getPermissionGroupId() == null) {
            return false;
        }
        if (other.getPermissionGroupId() != null && !other.getPermissionGroupId().equals(this.getPermissionGroupId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getApplicationPermissions() == null ^ this.getApplicationPermissions() == null) {
            return false;
        }
        if (other.getApplicationPermissions() != null && !other.getApplicationPermissions().equals(this.getApplicationPermissions())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        return other.getLastModifiedTime() == null || other.getLastModifiedTime().equals(this.getLastModifiedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPermissionGroupId() == null ? 0 : this.getPermissionGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationPermissions() == null ? 0 : this.getApplicationPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        return hashCode;
    }

    public PermissionGroup clone() {
        try {
            return (PermissionGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PermissionGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

