/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.finspace.model.transform.KxDataviewSegmentConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KxDataviewSegmentConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> dbPaths;
    private String volumeName;
    private Boolean onDemand;

    public List<String> getDbPaths() {
        return this.dbPaths;
    }

    public void setDbPaths(Collection<String> dbPaths) {
        if (dbPaths == null) {
            this.dbPaths = null;
            return;
        }
        this.dbPaths = new ArrayList<String>(dbPaths);
    }

    public KxDataviewSegmentConfiguration withDbPaths(String ... dbPaths) {
        if (this.dbPaths == null) {
            this.setDbPaths(new ArrayList<String>(dbPaths.length));
        }
        for (String ele : dbPaths) {
            this.dbPaths.add(ele);
        }
        return this;
    }

    public KxDataviewSegmentConfiguration withDbPaths(Collection<String> dbPaths) {
        this.setDbPaths(dbPaths);
        return this;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public KxDataviewSegmentConfiguration withVolumeName(String volumeName) {
        this.setVolumeName(volumeName);
        return this;
    }

    public void setOnDemand(Boolean onDemand) {
        this.onDemand = onDemand;
    }

    public Boolean getOnDemand() {
        return this.onDemand;
    }

    public KxDataviewSegmentConfiguration withOnDemand(Boolean onDemand) {
        this.setOnDemand(onDemand);
        return this;
    }

    public Boolean isOnDemand() {
        return this.onDemand;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDbPaths() != null) {
            sb.append("DbPaths: ").append(this.getDbPaths()).append(",");
        }
        if (this.getVolumeName() != null) {
            sb.append("VolumeName: ").append(this.getVolumeName()).append(",");
        }
        if (this.getOnDemand() != null) {
            sb.append("OnDemand: ").append(this.getOnDemand());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDataviewSegmentConfiguration)) {
            return false;
        }
        KxDataviewSegmentConfiguration other = (KxDataviewSegmentConfiguration)obj;
        if (other.getDbPaths() == null ^ this.getDbPaths() == null) {
            return false;
        }
        if (other.getDbPaths() != null && !other.getDbPaths().equals(this.getDbPaths())) {
            return false;
        }
        if (other.getVolumeName() == null ^ this.getVolumeName() == null) {
            return false;
        }
        if (other.getVolumeName() != null && !other.getVolumeName().equals(this.getVolumeName())) {
            return false;
        }
        if (other.getOnDemand() == null ^ this.getOnDemand() == null) {
            return false;
        }
        return other.getOnDemand() == null || other.getOnDemand().equals(this.getOnDemand());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDbPaths() == null ? 0 : this.getDbPaths().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeName() == null ? 0 : this.getVolumeName().hashCode());
        hashCode = 31 * hashCode + (this.getOnDemand() == null ? 0 : this.getOnDemand().hashCode());
        return hashCode;
    }

    public KxDataviewSegmentConfiguration clone() {
        try {
            return (KxDataviewSegmentConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KxDataviewSegmentConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

