/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.finspace.model.KxAzMode;
import com.amazonaws.services.finspace.model.KxDataviewSegmentConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateKxDataviewRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String environmentId;
    private String databaseName;
    private String dataviewName;
    private String azMode;
    private String availabilityZoneId;
    private String changesetId;
    private List<KxDataviewSegmentConfiguration> segmentConfigurations;
    private Boolean autoUpdate;
    private Boolean readWrite;
    private String description;
    private Map<String, String> tags;
    private String clientToken;

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public CreateKxDataviewRequest withEnvironmentId(String environmentId) {
        this.setEnvironmentId(environmentId);
        return this;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public CreateKxDataviewRequest withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public void setDataviewName(String dataviewName) {
        this.dataviewName = dataviewName;
    }

    public String getDataviewName() {
        return this.dataviewName;
    }

    public CreateKxDataviewRequest withDataviewName(String dataviewName) {
        this.setDataviewName(dataviewName);
        return this;
    }

    public void setAzMode(String azMode) {
        this.azMode = azMode;
    }

    public String getAzMode() {
        return this.azMode;
    }

    public CreateKxDataviewRequest withAzMode(String azMode) {
        this.setAzMode(azMode);
        return this;
    }

    public CreateKxDataviewRequest withAzMode(KxAzMode azMode) {
        this.azMode = azMode.toString();
        return this;
    }

    public void setAvailabilityZoneId(String availabilityZoneId) {
        this.availabilityZoneId = availabilityZoneId;
    }

    public String getAvailabilityZoneId() {
        return this.availabilityZoneId;
    }

    public CreateKxDataviewRequest withAvailabilityZoneId(String availabilityZoneId) {
        this.setAvailabilityZoneId(availabilityZoneId);
        return this;
    }

    public void setChangesetId(String changesetId) {
        this.changesetId = changesetId;
    }

    public String getChangesetId() {
        return this.changesetId;
    }

    public CreateKxDataviewRequest withChangesetId(String changesetId) {
        this.setChangesetId(changesetId);
        return this;
    }

    public List<KxDataviewSegmentConfiguration> getSegmentConfigurations() {
        return this.segmentConfigurations;
    }

    public void setSegmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations) {
        if (segmentConfigurations == null) {
            this.segmentConfigurations = null;
            return;
        }
        this.segmentConfigurations = new ArrayList<KxDataviewSegmentConfiguration>(segmentConfigurations);
    }

    public CreateKxDataviewRequest withSegmentConfigurations(KxDataviewSegmentConfiguration ... segmentConfigurations) {
        if (this.segmentConfigurations == null) {
            this.setSegmentConfigurations(new ArrayList<KxDataviewSegmentConfiguration>(segmentConfigurations.length));
        }
        for (KxDataviewSegmentConfiguration ele : segmentConfigurations) {
            this.segmentConfigurations.add(ele);
        }
        return this;
    }

    public CreateKxDataviewRequest withSegmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations) {
        this.setSegmentConfigurations(segmentConfigurations);
        return this;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public Boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    public CreateKxDataviewRequest withAutoUpdate(Boolean autoUpdate) {
        this.setAutoUpdate(autoUpdate);
        return this;
    }

    public Boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setReadWrite(Boolean readWrite) {
        this.readWrite = readWrite;
    }

    public Boolean getReadWrite() {
        return this.readWrite;
    }

    public CreateKxDataviewRequest withReadWrite(Boolean readWrite) {
        this.setReadWrite(readWrite);
        return this;
    }

    public Boolean isReadWrite() {
        return this.readWrite;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateKxDataviewRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateKxDataviewRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateKxDataviewRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateKxDataviewRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateKxDataviewRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnvironmentId() != null) {
            sb.append("EnvironmentId: ").append(this.getEnvironmentId()).append(",");
        }
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getDataviewName() != null) {
            sb.append("DataviewName: ").append(this.getDataviewName()).append(",");
        }
        if (this.getAzMode() != null) {
            sb.append("AzMode: ").append(this.getAzMode()).append(",");
        }
        if (this.getAvailabilityZoneId() != null) {
            sb.append("AvailabilityZoneId: ").append(this.getAvailabilityZoneId()).append(",");
        }
        if (this.getChangesetId() != null) {
            sb.append("ChangesetId: ").append(this.getChangesetId()).append(",");
        }
        if (this.getSegmentConfigurations() != null) {
            sb.append("SegmentConfigurations: ").append(this.getSegmentConfigurations()).append(",");
        }
        if (this.getAutoUpdate() != null) {
            sb.append("AutoUpdate: ").append(this.getAutoUpdate()).append(",");
        }
        if (this.getReadWrite() != null) {
            sb.append("ReadWrite: ").append(this.getReadWrite()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxDataviewRequest)) {
            return false;
        }
        CreateKxDataviewRequest other = (CreateKxDataviewRequest)obj;
        if (other.getEnvironmentId() == null ^ this.getEnvironmentId() == null) {
            return false;
        }
        if (other.getEnvironmentId() != null && !other.getEnvironmentId().equals(this.getEnvironmentId())) {
            return false;
        }
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getDataviewName() == null ^ this.getDataviewName() == null) {
            return false;
        }
        if (other.getDataviewName() != null && !other.getDataviewName().equals(this.getDataviewName())) {
            return false;
        }
        if (other.getAzMode() == null ^ this.getAzMode() == null) {
            return false;
        }
        if (other.getAzMode() != null && !other.getAzMode().equals(this.getAzMode())) {
            return false;
        }
        if (other.getAvailabilityZoneId() == null ^ this.getAvailabilityZoneId() == null) {
            return false;
        }
        if (other.getAvailabilityZoneId() != null && !other.getAvailabilityZoneId().equals(this.getAvailabilityZoneId())) {
            return false;
        }
        if (other.getChangesetId() == null ^ this.getChangesetId() == null) {
            return false;
        }
        if (other.getChangesetId() != null && !other.getChangesetId().equals(this.getChangesetId())) {
            return false;
        }
        if (other.getSegmentConfigurations() == null ^ this.getSegmentConfigurations() == null) {
            return false;
        }
        if (other.getSegmentConfigurations() != null && !other.getSegmentConfigurations().equals(this.getSegmentConfigurations())) {
            return false;
        }
        if (other.getAutoUpdate() == null ^ this.getAutoUpdate() == null) {
            return false;
        }
        if (other.getAutoUpdate() != null && !other.getAutoUpdate().equals(this.getAutoUpdate())) {
            return false;
        }
        if (other.getReadWrite() == null ^ this.getReadWrite() == null) {
            return false;
        }
        if (other.getReadWrite() != null && !other.getReadWrite().equals(this.getReadWrite())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnvironmentId() == null ? 0 : this.getEnvironmentId().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getDataviewName() == null ? 0 : this.getDataviewName().hashCode());
        hashCode = 31 * hashCode + (this.getAzMode() == null ? 0 : this.getAzMode().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZoneId() == null ? 0 : this.getAvailabilityZoneId().hashCode());
        hashCode = 31 * hashCode + (this.getChangesetId() == null ? 0 : this.getChangesetId().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentConfigurations() == null ? 0 : this.getSegmentConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getAutoUpdate() == null ? 0 : this.getAutoUpdate().hashCode());
        hashCode = 31 * hashCode + (this.getReadWrite() == null ? 0 : this.getReadWrite().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreateKxDataviewRequest clone() {
        return (CreateKxDataviewRequest)super.clone();
    }
}

