/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEventsAsync;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEventsClient;
import com.amazonaws.services.cloudwatchevents.model.DeleteRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.DescribeRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.DescribeRuleResult;
import com.amazonaws.services.cloudwatchevents.model.DisableRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.EnableRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.ListRuleNamesByTargetRequest;
import com.amazonaws.services.cloudwatchevents.model.ListRuleNamesByTargetResult;
import com.amazonaws.services.cloudwatchevents.model.ListRulesRequest;
import com.amazonaws.services.cloudwatchevents.model.ListRulesResult;
import com.amazonaws.services.cloudwatchevents.model.ListTargetsByRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.ListTargetsByRuleResult;
import com.amazonaws.services.cloudwatchevents.model.PutEventsRequest;
import com.amazonaws.services.cloudwatchevents.model.PutEventsResult;
import com.amazonaws.services.cloudwatchevents.model.PutRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.PutRuleResult;
import com.amazonaws.services.cloudwatchevents.model.PutTargetsRequest;
import com.amazonaws.services.cloudwatchevents.model.PutTargetsResult;
import com.amazonaws.services.cloudwatchevents.model.RemoveTargetsRequest;
import com.amazonaws.services.cloudwatchevents.model.RemoveTargetsResult;
import com.amazonaws.services.cloudwatchevents.model.TestEventPatternRequest;
import com.amazonaws.services.cloudwatchevents.model.TestEventPatternResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudWatchEventsAsyncClient
extends AmazonCloudWatchEventsClient
implements AmazonCloudWatchEventsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonCloudWatchEventsAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCloudWatchEventsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudWatchEventsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudWatchEventsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonCloudWatchEventsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudWatchEventsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudWatchEventsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudWatchEventsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonCloudWatchEventsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<Void> deleteRuleAsync(DeleteRuleRequest request) {
        return this.deleteRuleAsync(request, null);
    }

    @Override
    public Future<Void> deleteRuleAsync(final DeleteRuleRequest request, final AsyncHandler<DeleteRuleRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudWatchEventsAsyncClient.this.deleteRule(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRuleResult> describeRuleAsync(DescribeRuleRequest request) {
        return this.describeRuleAsync(request, null);
    }

    @Override
    public Future<DescribeRuleResult> describeRuleAsync(final DescribeRuleRequest request, final AsyncHandler<DescribeRuleRequest, DescribeRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeRuleResult>(){

            @Override
            public DescribeRuleResult call() throws Exception {
                DescribeRuleResult result;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.describeRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> disableRuleAsync(DisableRuleRequest request) {
        return this.disableRuleAsync(request, null);
    }

    @Override
    public Future<Void> disableRuleAsync(final DisableRuleRequest request, final AsyncHandler<DisableRuleRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudWatchEventsAsyncClient.this.disableRule(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> enableRuleAsync(EnableRuleRequest request) {
        return this.enableRuleAsync(request, null);
    }

    @Override
    public Future<Void> enableRuleAsync(final EnableRuleRequest request, final AsyncHandler<EnableRuleRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudWatchEventsAsyncClient.this.enableRule(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRuleNamesByTargetResult> listRuleNamesByTargetAsync(ListRuleNamesByTargetRequest request) {
        return this.listRuleNamesByTargetAsync(request, null);
    }

    @Override
    public Future<ListRuleNamesByTargetResult> listRuleNamesByTargetAsync(final ListRuleNamesByTargetRequest request, final AsyncHandler<ListRuleNamesByTargetRequest, ListRuleNamesByTargetResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRuleNamesByTargetResult>(){

            @Override
            public ListRuleNamesByTargetResult call() throws Exception {
                ListRuleNamesByTargetResult result;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.listRuleNamesByTarget(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRulesResult> listRulesAsync(ListRulesRequest request) {
        return this.listRulesAsync(request, null);
    }

    @Override
    public Future<ListRulesResult> listRulesAsync(final ListRulesRequest request, final AsyncHandler<ListRulesRequest, ListRulesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRulesResult>(){

            @Override
            public ListRulesResult call() throws Exception {
                ListRulesResult result;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.listRules(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTargetsByRuleResult> listTargetsByRuleAsync(ListTargetsByRuleRequest request) {
        return this.listTargetsByRuleAsync(request, null);
    }

    @Override
    public Future<ListTargetsByRuleResult> listTargetsByRuleAsync(final ListTargetsByRuleRequest request, final AsyncHandler<ListTargetsByRuleRequest, ListTargetsByRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTargetsByRuleResult>(){

            @Override
            public ListTargetsByRuleResult call() throws Exception {
                ListTargetsByRuleResult result;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.listTargetsByRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutEventsResult> putEventsAsync(PutEventsRequest request) {
        return this.putEventsAsync(request, null);
    }

    @Override
    public Future<PutEventsResult> putEventsAsync(final PutEventsRequest request, final AsyncHandler<PutEventsRequest, PutEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutEventsResult>(){

            @Override
            public PutEventsResult call() throws Exception {
                PutEventsResult result;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.putEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRuleResult> putRuleAsync(PutRuleRequest request) {
        return this.putRuleAsync(request, null);
    }

    @Override
    public Future<PutRuleResult> putRuleAsync(final PutRuleRequest request, final AsyncHandler<PutRuleRequest, PutRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutRuleResult>(){

            @Override
            public PutRuleResult call() throws Exception {
                PutRuleResult result;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.putRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutTargetsResult> putTargetsAsync(PutTargetsRequest request) {
        return this.putTargetsAsync(request, null);
    }

    @Override
    public Future<PutTargetsResult> putTargetsAsync(final PutTargetsRequest request, final AsyncHandler<PutTargetsRequest, PutTargetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutTargetsResult>(){

            @Override
            public PutTargetsResult call() throws Exception {
                PutTargetsResult result;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.putTargets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTargetsResult> removeTargetsAsync(RemoveTargetsRequest request) {
        return this.removeTargetsAsync(request, null);
    }

    @Override
    public Future<RemoveTargetsResult> removeTargetsAsync(final RemoveTargetsRequest request, final AsyncHandler<RemoveTargetsRequest, RemoveTargetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveTargetsResult>(){

            @Override
            public RemoveTargetsResult call() throws Exception {
                RemoveTargetsResult result;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.removeTargets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestEventPatternResult> testEventPatternAsync(TestEventPatternRequest request) {
        return this.testEventPatternAsync(request, null);
    }

    @Override
    public Future<TestEventPatternResult> testEventPatternAsync(final TestEventPatternRequest request, final AsyncHandler<TestEventPatternRequest, TestEventPatternResult> asyncHandler) {
        return this.executorService.submit(new Callable<TestEventPatternResult>(){

            @Override
            public TestEventPatternResult call() throws Exception {
                TestEventPatternResult result;
                try {
                    result = AmazonCloudWatchEventsAsyncClient.this.testEventPattern(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

