/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eventbridge.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.Replay;
import java.util.Date;

@SdkInternalApi
public class ReplayMarshaller {
    private static final MarshallingInfo<String> REPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplayName").build();
    private static final MarshallingInfo<String> EVENTSOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventSourceArn").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateReason").build();
    private static final MarshallingInfo<Date> EVENTSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> EVENTENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> EVENTLASTREPLAYEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventLastReplayedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> REPLAYSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplayStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> REPLAYENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplayEndTime").timestampFormat("unixTimestamp").build();
    private static final ReplayMarshaller instance = new ReplayMarshaller();

    public static ReplayMarshaller getInstance() {
        return instance;
    }

    public void marshall(Replay replay, ProtocolMarshaller protocolMarshaller) {
        if (replay == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)replay.getReplayName(), REPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)replay.getEventSourceArn(), EVENTSOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)replay.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)replay.getStateReason(), STATEREASON_BINDING);
            protocolMarshaller.marshall((Object)replay.getEventStartTime(), EVENTSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)replay.getEventEndTime(), EVENTENDTIME_BINDING);
            protocolMarshaller.marshall((Object)replay.getEventLastReplayedTime(), EVENTLASTREPLAYEDTIME_BINDING);
            protocolMarshaller.marshall((Object)replay.getReplayStartTime(), REPLAYSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)replay.getReplayEndTime(), REPLAYENDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

