/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.entityresolution;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.entityresolution.AWSEntityResolution;
import com.amazonaws.services.entityresolution.AWSEntityResolutionClientBuilder;
import com.amazonaws.services.entityresolution.model.AWSEntityResolutionException;
import com.amazonaws.services.entityresolution.model.CreateMatchingWorkflowRequest;
import com.amazonaws.services.entityresolution.model.CreateMatchingWorkflowResult;
import com.amazonaws.services.entityresolution.model.CreateSchemaMappingRequest;
import com.amazonaws.services.entityresolution.model.CreateSchemaMappingResult;
import com.amazonaws.services.entityresolution.model.DeleteMatchingWorkflowRequest;
import com.amazonaws.services.entityresolution.model.DeleteMatchingWorkflowResult;
import com.amazonaws.services.entityresolution.model.DeleteSchemaMappingRequest;
import com.amazonaws.services.entityresolution.model.DeleteSchemaMappingResult;
import com.amazonaws.services.entityresolution.model.GetMatchIdRequest;
import com.amazonaws.services.entityresolution.model.GetMatchIdResult;
import com.amazonaws.services.entityresolution.model.GetMatchingJobRequest;
import com.amazonaws.services.entityresolution.model.GetMatchingJobResult;
import com.amazonaws.services.entityresolution.model.GetMatchingWorkflowRequest;
import com.amazonaws.services.entityresolution.model.GetMatchingWorkflowResult;
import com.amazonaws.services.entityresolution.model.GetSchemaMappingRequest;
import com.amazonaws.services.entityresolution.model.GetSchemaMappingResult;
import com.amazonaws.services.entityresolution.model.ListMatchingJobsRequest;
import com.amazonaws.services.entityresolution.model.ListMatchingJobsResult;
import com.amazonaws.services.entityresolution.model.ListMatchingWorkflowsRequest;
import com.amazonaws.services.entityresolution.model.ListMatchingWorkflowsResult;
import com.amazonaws.services.entityresolution.model.ListSchemaMappingsRequest;
import com.amazonaws.services.entityresolution.model.ListSchemaMappingsResult;
import com.amazonaws.services.entityresolution.model.ListTagsForResourceRequest;
import com.amazonaws.services.entityresolution.model.ListTagsForResourceResult;
import com.amazonaws.services.entityresolution.model.StartMatchingJobRequest;
import com.amazonaws.services.entityresolution.model.StartMatchingJobResult;
import com.amazonaws.services.entityresolution.model.TagResourceRequest;
import com.amazonaws.services.entityresolution.model.TagResourceResult;
import com.amazonaws.services.entityresolution.model.UntagResourceRequest;
import com.amazonaws.services.entityresolution.model.UntagResourceResult;
import com.amazonaws.services.entityresolution.model.UpdateMatchingWorkflowRequest;
import com.amazonaws.services.entityresolution.model.UpdateMatchingWorkflowResult;
import com.amazonaws.services.entityresolution.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.CreateMatchingWorkflowRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.CreateMatchingWorkflowResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.CreateSchemaMappingRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.CreateSchemaMappingResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.DeleteMatchingWorkflowRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.DeleteMatchingWorkflowResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.DeleteSchemaMappingRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.DeleteSchemaMappingResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.ExceedsLimitExceptionUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.GetMatchIdRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.GetMatchIdResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.GetMatchingJobRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.GetMatchingJobResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.GetMatchingWorkflowRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.GetMatchingWorkflowResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.GetSchemaMappingRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.GetSchemaMappingResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.ListMatchingJobsRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.ListMatchingJobsResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.ListMatchingWorkflowsRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.ListMatchingWorkflowsResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.ListSchemaMappingsRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.ListSchemaMappingsResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.StartMatchingJobRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.StartMatchingJobResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.UpdateMatchingWorkflowRequestProtocolMarshaller;
import com.amazonaws.services.entityresolution.model.transform.UpdateMatchingWorkflowResultJsonUnmarshaller;
import com.amazonaws.services.entityresolution.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSEntityResolutionClient
extends AmazonWebServiceClient
implements AWSEntityResolution {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSEntityResolution.class);
    private static final String DEFAULT_SIGNING_NAME = "entityresolution";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExceedsLimitException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ExceedsLimitExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSEntityResolutionException.class));

    public static AWSEntityResolutionClientBuilder builder() {
        return AWSEntityResolutionClientBuilder.standard();
    }

    AWSEntityResolutionClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSEntityResolutionClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("entityresolution.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/entityresolution/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/entityresolution/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateMatchingWorkflowResult createMatchingWorkflow(CreateMatchingWorkflowRequest request) {
        request = (CreateMatchingWorkflowRequest)this.beforeClientExecution(request);
        return this.executeCreateMatchingWorkflow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMatchingWorkflowResult executeCreateMatchingWorkflow(CreateMatchingWorkflowRequest createMatchingWorkflowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMatchingWorkflowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMatchingWorkflowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMatchingWorkflowRequestProtocolMarshaller(protocolFactory).marshall((CreateMatchingWorkflowRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMatchingWorkflowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateMatchingWorkflow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMatchingWorkflowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMatchingWorkflowResult createMatchingWorkflowResult = (CreateMatchingWorkflowResult)response.getAwsResponse();
            return createMatchingWorkflowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSchemaMappingResult createSchemaMapping(CreateSchemaMappingRequest request) {
        request = (CreateSchemaMappingRequest)this.beforeClientExecution(request);
        return this.executeCreateSchemaMapping(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSchemaMappingResult executeCreateSchemaMapping(CreateSchemaMappingRequest createSchemaMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSchemaMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSchemaMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSchemaMappingRequestProtocolMarshaller(protocolFactory).marshall((CreateSchemaMappingRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSchemaMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSchemaMapping");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSchemaMappingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSchemaMappingResult createSchemaMappingResult = (CreateSchemaMappingResult)response.getAwsResponse();
            return createSchemaMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMatchingWorkflowResult deleteMatchingWorkflow(DeleteMatchingWorkflowRequest request) {
        request = (DeleteMatchingWorkflowRequest)this.beforeClientExecution(request);
        return this.executeDeleteMatchingWorkflow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMatchingWorkflowResult executeDeleteMatchingWorkflow(DeleteMatchingWorkflowRequest deleteMatchingWorkflowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMatchingWorkflowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMatchingWorkflowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMatchingWorkflowRequestProtocolMarshaller(protocolFactory).marshall((DeleteMatchingWorkflowRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMatchingWorkflowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMatchingWorkflow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMatchingWorkflowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMatchingWorkflowResult deleteMatchingWorkflowResult = (DeleteMatchingWorkflowResult)response.getAwsResponse();
            return deleteMatchingWorkflowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSchemaMappingResult deleteSchemaMapping(DeleteSchemaMappingRequest request) {
        request = (DeleteSchemaMappingRequest)this.beforeClientExecution(request);
        return this.executeDeleteSchemaMapping(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSchemaMappingResult executeDeleteSchemaMapping(DeleteSchemaMappingRequest deleteSchemaMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSchemaMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSchemaMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSchemaMappingRequestProtocolMarshaller(protocolFactory).marshall((DeleteSchemaMappingRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSchemaMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSchemaMapping");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSchemaMappingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSchemaMappingResult deleteSchemaMappingResult = (DeleteSchemaMappingResult)response.getAwsResponse();
            return deleteSchemaMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMatchIdResult getMatchId(GetMatchIdRequest request) {
        request = (GetMatchIdRequest)this.beforeClientExecution(request);
        return this.executeGetMatchId(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMatchIdResult executeGetMatchId(GetMatchIdRequest getMatchIdRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMatchIdRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMatchIdRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMatchIdRequestProtocolMarshaller(protocolFactory).marshall((GetMatchIdRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMatchIdRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMatchId");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMatchIdResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMatchIdResult getMatchIdResult = (GetMatchIdResult)response.getAwsResponse();
            return getMatchIdResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMatchingJobResult getMatchingJob(GetMatchingJobRequest request) {
        request = (GetMatchingJobRequest)this.beforeClientExecution(request);
        return this.executeGetMatchingJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMatchingJobResult executeGetMatchingJob(GetMatchingJobRequest getMatchingJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMatchingJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMatchingJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMatchingJobRequestProtocolMarshaller(protocolFactory).marshall((GetMatchingJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMatchingJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMatchingJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMatchingJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMatchingJobResult getMatchingJobResult = (GetMatchingJobResult)response.getAwsResponse();
            return getMatchingJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMatchingWorkflowResult getMatchingWorkflow(GetMatchingWorkflowRequest request) {
        request = (GetMatchingWorkflowRequest)this.beforeClientExecution(request);
        return this.executeGetMatchingWorkflow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMatchingWorkflowResult executeGetMatchingWorkflow(GetMatchingWorkflowRequest getMatchingWorkflowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMatchingWorkflowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMatchingWorkflowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMatchingWorkflowRequestProtocolMarshaller(protocolFactory).marshall((GetMatchingWorkflowRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMatchingWorkflowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMatchingWorkflow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMatchingWorkflowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMatchingWorkflowResult getMatchingWorkflowResult = (GetMatchingWorkflowResult)response.getAwsResponse();
            return getMatchingWorkflowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSchemaMappingResult getSchemaMapping(GetSchemaMappingRequest request) {
        request = (GetSchemaMappingRequest)this.beforeClientExecution(request);
        return this.executeGetSchemaMapping(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSchemaMappingResult executeGetSchemaMapping(GetSchemaMappingRequest getSchemaMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSchemaMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSchemaMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSchemaMappingRequestProtocolMarshaller(protocolFactory).marshall((GetSchemaMappingRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSchemaMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSchemaMapping");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSchemaMappingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSchemaMappingResult getSchemaMappingResult = (GetSchemaMappingResult)response.getAwsResponse();
            return getSchemaMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMatchingJobsResult listMatchingJobs(ListMatchingJobsRequest request) {
        request = (ListMatchingJobsRequest)this.beforeClientExecution(request);
        return this.executeListMatchingJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMatchingJobsResult executeListMatchingJobs(ListMatchingJobsRequest listMatchingJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMatchingJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMatchingJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMatchingJobsRequestProtocolMarshaller(protocolFactory).marshall((ListMatchingJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMatchingJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMatchingJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMatchingJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMatchingJobsResult listMatchingJobsResult = (ListMatchingJobsResult)response.getAwsResponse();
            return listMatchingJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMatchingWorkflowsResult listMatchingWorkflows(ListMatchingWorkflowsRequest request) {
        request = (ListMatchingWorkflowsRequest)this.beforeClientExecution(request);
        return this.executeListMatchingWorkflows(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMatchingWorkflowsResult executeListMatchingWorkflows(ListMatchingWorkflowsRequest listMatchingWorkflowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMatchingWorkflowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMatchingWorkflowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMatchingWorkflowsRequestProtocolMarshaller(protocolFactory).marshall((ListMatchingWorkflowsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMatchingWorkflowsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMatchingWorkflows");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMatchingWorkflowsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMatchingWorkflowsResult listMatchingWorkflowsResult = (ListMatchingWorkflowsResult)response.getAwsResponse();
            return listMatchingWorkflowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSchemaMappingsResult listSchemaMappings(ListSchemaMappingsRequest request) {
        request = (ListSchemaMappingsRequest)this.beforeClientExecution(request);
        return this.executeListSchemaMappings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSchemaMappingsResult executeListSchemaMappings(ListSchemaMappingsRequest listSchemaMappingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSchemaMappingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSchemaMappingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSchemaMappingsRequestProtocolMarshaller(protocolFactory).marshall((ListSchemaMappingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSchemaMappingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSchemaMappings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSchemaMappingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSchemaMappingsResult listSchemaMappingsResult = (ListSchemaMappingsResult)response.getAwsResponse();
            return listSchemaMappingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartMatchingJobResult startMatchingJob(StartMatchingJobRequest request) {
        request = (StartMatchingJobRequest)this.beforeClientExecution(request);
        return this.executeStartMatchingJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartMatchingJobResult executeStartMatchingJob(StartMatchingJobRequest startMatchingJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startMatchingJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartMatchingJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartMatchingJobRequestProtocolMarshaller(protocolFactory).marshall((StartMatchingJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startMatchingJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartMatchingJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartMatchingJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartMatchingJobResult startMatchingJobResult = (StartMatchingJobResult)response.getAwsResponse();
            return startMatchingJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateMatchingWorkflowResult updateMatchingWorkflow(UpdateMatchingWorkflowRequest request) {
        request = (UpdateMatchingWorkflowRequest)this.beforeClientExecution(request);
        return this.executeUpdateMatchingWorkflow(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateMatchingWorkflowResult executeUpdateMatchingWorkflow(UpdateMatchingWorkflowRequest updateMatchingWorkflowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateMatchingWorkflowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateMatchingWorkflowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateMatchingWorkflowRequestProtocolMarshaller(protocolFactory).marshall((UpdateMatchingWorkflowRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateMatchingWorkflowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EntityResolution");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateMatchingWorkflow");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateMatchingWorkflowResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateMatchingWorkflowResult updateMatchingWorkflowResult = (UpdateMatchingWorkflowResult)response.getAwsResponse();
            return updateMatchingWorkflowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

