/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrcontainers.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.emrcontainers.model.Configuration;
import com.amazonaws.services.emrcontainers.model.ParametricMonitoringConfiguration;
import com.amazonaws.services.emrcontainers.model.transform.ParametricConfigurationOverridesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ParametricConfigurationOverrides
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Configuration> applicationConfiguration;
    private ParametricMonitoringConfiguration monitoringConfiguration;

    public List<Configuration> getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public void setApplicationConfiguration(Collection<Configuration> applicationConfiguration) {
        if (applicationConfiguration == null) {
            this.applicationConfiguration = null;
            return;
        }
        this.applicationConfiguration = new ArrayList<Configuration>(applicationConfiguration);
    }

    public ParametricConfigurationOverrides withApplicationConfiguration(Configuration ... applicationConfiguration) {
        if (this.applicationConfiguration == null) {
            this.setApplicationConfiguration(new ArrayList<Configuration>(applicationConfiguration.length));
        }
        for (Configuration ele : applicationConfiguration) {
            this.applicationConfiguration.add(ele);
        }
        return this;
    }

    public ParametricConfigurationOverrides withApplicationConfiguration(Collection<Configuration> applicationConfiguration) {
        this.setApplicationConfiguration(applicationConfiguration);
        return this;
    }

    public void setMonitoringConfiguration(ParametricMonitoringConfiguration monitoringConfiguration) {
        this.monitoringConfiguration = monitoringConfiguration;
    }

    public ParametricMonitoringConfiguration getMonitoringConfiguration() {
        return this.monitoringConfiguration;
    }

    public ParametricConfigurationOverrides withMonitoringConfiguration(ParametricMonitoringConfiguration monitoringConfiguration) {
        this.setMonitoringConfiguration(monitoringConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationConfiguration() != null) {
            sb.append("ApplicationConfiguration: ").append(this.getApplicationConfiguration()).append(",");
        }
        if (this.getMonitoringConfiguration() != null) {
            sb.append("MonitoringConfiguration: ").append(this.getMonitoringConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParametricConfigurationOverrides)) {
            return false;
        }
        ParametricConfigurationOverrides other = (ParametricConfigurationOverrides)obj;
        if (other.getApplicationConfiguration() == null ^ this.getApplicationConfiguration() == null) {
            return false;
        }
        if (other.getApplicationConfiguration() != null && !other.getApplicationConfiguration().equals(this.getApplicationConfiguration())) {
            return false;
        }
        if (other.getMonitoringConfiguration() == null ^ this.getMonitoringConfiguration() == null) {
            return false;
        }
        return other.getMonitoringConfiguration() == null || other.getMonitoringConfiguration().equals(this.getMonitoringConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationConfiguration() == null ? 0 : this.getApplicationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringConfiguration() == null ? 0 : this.getMonitoringConfiguration().hashCode());
        return hashCode;
    }

    public ParametricConfigurationOverrides clone() {
        try {
            return (ParametricConfigurationOverrides)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParametricConfigurationOverridesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

