/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.StudioSummary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListStudiosResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<StudioSummary> studios;
    private String marker;

    public List<StudioSummary> getStudios() {
        if (this.studios == null) {
            this.studios = new SdkInternalList();
        }
        return this.studios;
    }

    public void setStudios(Collection<StudioSummary> studios) {
        if (studios == null) {
            this.studios = null;
            return;
        }
        this.studios = new SdkInternalList(studios);
    }

    public ListStudiosResult withStudios(StudioSummary ... studios) {
        if (this.studios == null) {
            this.setStudios((Collection<StudioSummary>)new SdkInternalList(studios.length));
        }
        for (StudioSummary ele : studios) {
            this.studios.add((Object)ele);
        }
        return this;
    }

    public ListStudiosResult withStudios(Collection<StudioSummary> studios) {
        this.setStudios(studios);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListStudiosResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStudios() != null) {
            sb.append("Studios: ").append(this.getStudios()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudiosResult)) {
            return false;
        }
        ListStudiosResult other = (ListStudiosResult)obj;
        if (other.getStudios() == null ^ this.getStudios() == null) {
            return false;
        }
        if (other.getStudios() != null && !other.getStudios().equals(this.getStudios())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStudios() == null ? 0 : this.getStudios().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListStudiosResult clone() {
        try {
            return (ListStudiosResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

