/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.ScalingRule;
import com.amazonaws.services.elasticmapreduce.model.transform.ScalingActionJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ScalingTriggerJsonMarshaller;

public class ScalingRuleJsonMarshaller {
    private static ScalingRuleJsonMarshaller instance;

    public void marshall(ScalingRule scalingRule, StructuredJsonGenerator jsonGenerator) {
        if (scalingRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (scalingRule.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(scalingRule.getName());
            }
            if (scalingRule.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(scalingRule.getDescription());
            }
            if (scalingRule.getAction() != null) {
                jsonGenerator.writeFieldName("Action");
                ScalingActionJsonMarshaller.getInstance().marshall(scalingRule.getAction(), jsonGenerator);
            }
            if (scalingRule.getTrigger() != null) {
                jsonGenerator.writeFieldName("Trigger");
                ScalingTriggerJsonMarshaller.getInstance().marshall(scalingRule.getTrigger(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ScalingRuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ScalingRuleJsonMarshaller();
        }
        return instance;
    }
}

