/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.ClusterStatus;
import com.amazonaws.services.elasticmapreduce.model.transform.ClusterStateChangeReasonJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ClusterTimelineJsonMarshaller;

public class ClusterStatusJsonMarshaller {
    private static ClusterStatusJsonMarshaller instance;

    public void marshall(ClusterStatus clusterStatus, StructuredJsonGenerator jsonGenerator) {
        if (clusterStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (clusterStatus.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(clusterStatus.getState());
            }
            if (clusterStatus.getStateChangeReason() != null) {
                jsonGenerator.writeFieldName("StateChangeReason");
                ClusterStateChangeReasonJsonMarshaller.getInstance().marshall(clusterStatus.getStateChangeReason(), jsonGenerator);
            }
            if (clusterStatus.getTimeline() != null) {
                jsonGenerator.writeFieldName("Timeline");
                ClusterTimelineJsonMarshaller.getInstance().marshall(clusterStatus.getTimeline(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ClusterStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ClusterStatusJsonMarshaller();
        }
        return instance;
    }
}

