/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupStatus;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceGroupStateChangeReasonJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceGroupTimelineJsonMarshaller;

public class InstanceGroupStatusJsonMarshaller {
    private static InstanceGroupStatusJsonMarshaller instance;

    public void marshall(InstanceGroupStatus instanceGroupStatus, StructuredJsonGenerator jsonGenerator) {
        if (instanceGroupStatus == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (instanceGroupStatus.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(instanceGroupStatus.getState());
            }
            if (instanceGroupStatus.getStateChangeReason() != null) {
                jsonGenerator.writeFieldName("StateChangeReason");
                InstanceGroupStateChangeReasonJsonMarshaller.getInstance().marshall(instanceGroupStatus.getStateChangeReason(), jsonGenerator);
            }
            if (instanceGroupStatus.getTimeline() != null) {
                jsonGenerator.writeFieldName("Timeline");
                InstanceGroupTimelineJsonMarshaller.getInstance().marshall(instanceGroupStatus.getTimeline(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceGroupStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceGroupStatusJsonMarshaller();
        }
        return instance;
    }
}

