/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduce;
import com.amazonaws.services.elasticmapreduce.waiters.ClusterRunning;
import com.amazonaws.services.elasticmapreduce.waiters.DescribeClusterFunction;
import com.amazonaws.services.elasticmapreduce.waiters.DescribeStepFunction;
import com.amazonaws.services.elasticmapreduce.waiters.StepComplete;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonElasticMapReduceWaiters {
    private final AmazonElasticMapReduce client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonElasticMapReduceWaiters(AmazonElasticMapReduce client) {
        this.client = client;
    }

    public Waiter clusterRunning() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClusterFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterRunning.IsRUNNINGMatcher(), new ClusterRunning.IsWAITINGMatcher(), new ClusterRunning.IsTERMINATINGMatcher(), new ClusterRunning.IsTERMINATEDMatcher(), new ClusterRunning.IsTERMINATED_WITH_ERRORSMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter stepComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStepFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StepComplete.IsCOMPLETEDMatcher(), new StepComplete.IsFAILEDMatcher(), new StepComplete.IsCANCELLEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }
}

