/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.EbsConfiguration;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceTypeConfigMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceTypeConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String instanceType;
    private Integer weightedCapacity;
    private String bidPrice;
    private Double bidPriceAsPercentageOfOnDemandPrice;
    private EbsConfiguration ebsConfiguration;
    private SdkInternalList<Configuration> configurations;

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public InstanceTypeConfig withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setWeightedCapacity(Integer weightedCapacity) {
        this.weightedCapacity = weightedCapacity;
    }

    public Integer getWeightedCapacity() {
        return this.weightedCapacity;
    }

    public InstanceTypeConfig withWeightedCapacity(Integer weightedCapacity) {
        this.setWeightedCapacity(weightedCapacity);
        return this;
    }

    public void setBidPrice(String bidPrice) {
        this.bidPrice = bidPrice;
    }

    public String getBidPrice() {
        return this.bidPrice;
    }

    public InstanceTypeConfig withBidPrice(String bidPrice) {
        this.setBidPrice(bidPrice);
        return this;
    }

    public void setBidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
        this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
    }

    public Double getBidPriceAsPercentageOfOnDemandPrice() {
        return this.bidPriceAsPercentageOfOnDemandPrice;
    }

    public InstanceTypeConfig withBidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
        this.setBidPriceAsPercentageOfOnDemandPrice(bidPriceAsPercentageOfOnDemandPrice);
        return this;
    }

    public void setEbsConfiguration(EbsConfiguration ebsConfiguration) {
        this.ebsConfiguration = ebsConfiguration;
    }

    public EbsConfiguration getEbsConfiguration() {
        return this.ebsConfiguration;
    }

    public InstanceTypeConfig withEbsConfiguration(EbsConfiguration ebsConfiguration) {
        this.setEbsConfiguration(ebsConfiguration);
        return this;
    }

    public List<Configuration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new SdkInternalList();
        }
        return this.configurations;
    }

    public void setConfigurations(Collection<Configuration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new SdkInternalList(configurations);
    }

    public InstanceTypeConfig withConfigurations(Configuration ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations((Collection<Configuration>)new SdkInternalList(configurations.length));
        }
        for (Configuration ele : configurations) {
            this.configurations.add((Object)ele);
        }
        return this;
    }

    public InstanceTypeConfig withConfigurations(Collection<Configuration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getWeightedCapacity() != null) {
            sb.append("WeightedCapacity: ").append(this.getWeightedCapacity()).append(",");
        }
        if (this.getBidPrice() != null) {
            sb.append("BidPrice: ").append(this.getBidPrice()).append(",");
        }
        if (this.getBidPriceAsPercentageOfOnDemandPrice() != null) {
            sb.append("BidPriceAsPercentageOfOnDemandPrice: ").append(this.getBidPriceAsPercentageOfOnDemandPrice()).append(",");
        }
        if (this.getEbsConfiguration() != null) {
            sb.append("EbsConfiguration: ").append(this.getEbsConfiguration()).append(",");
        }
        if (this.getConfigurations() != null) {
            sb.append("Configurations: ").append(this.getConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeConfig)) {
            return false;
        }
        InstanceTypeConfig other = (InstanceTypeConfig)obj;
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getWeightedCapacity() == null ^ this.getWeightedCapacity() == null) {
            return false;
        }
        if (other.getWeightedCapacity() != null && !other.getWeightedCapacity().equals(this.getWeightedCapacity())) {
            return false;
        }
        if (other.getBidPrice() == null ^ this.getBidPrice() == null) {
            return false;
        }
        if (other.getBidPrice() != null && !other.getBidPrice().equals(this.getBidPrice())) {
            return false;
        }
        if (other.getBidPriceAsPercentageOfOnDemandPrice() == null ^ this.getBidPriceAsPercentageOfOnDemandPrice() == null) {
            return false;
        }
        if (other.getBidPriceAsPercentageOfOnDemandPrice() != null && !other.getBidPriceAsPercentageOfOnDemandPrice().equals(this.getBidPriceAsPercentageOfOnDemandPrice())) {
            return false;
        }
        if (other.getEbsConfiguration() == null ^ this.getEbsConfiguration() == null) {
            return false;
        }
        if (other.getEbsConfiguration() != null && !other.getEbsConfiguration().equals(this.getEbsConfiguration())) {
            return false;
        }
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        return other.getConfigurations() == null || other.getConfigurations().equals(this.getConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getWeightedCapacity() == null ? 0 : this.getWeightedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getBidPrice() == null ? 0 : this.getBidPrice().hashCode());
        hashCode = 31 * hashCode + (this.getBidPriceAsPercentageOfOnDemandPrice() == null ? 0 : this.getBidPriceAsPercentageOfOnDemandPrice().hashCode());
        hashCode = 31 * hashCode + (this.getEbsConfiguration() == null ? 0 : this.getEbsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        return hashCode;
    }

    public InstanceTypeConfig clone() {
        try {
            return (InstanceTypeConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceTypeConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

