/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig;
import com.amazonaws.services.elasticmapreduce.model.EbsConfiguration;
import com.amazonaws.services.elasticmapreduce.model.transform.EbsBlockDeviceConfigJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class EbsConfigurationJsonMarshaller {
    private static EbsConfigurationJsonMarshaller instance;

    public void marshall(EbsConfiguration ebsConfiguration, SdkJsonGenerator jsonGenerator) {
        if (ebsConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList ebsBlockDeviceConfigsList = (SdkInternalList)ebsConfiguration.getEbsBlockDeviceConfigs();
            if (!ebsBlockDeviceConfigsList.isEmpty() || !ebsBlockDeviceConfigsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EbsBlockDeviceConfigs");
                jsonGenerator.writeStartArray();
                for (EbsBlockDeviceConfig ebsBlockDeviceConfigsListValue : ebsBlockDeviceConfigsList) {
                    if (ebsBlockDeviceConfigsListValue == null) continue;
                    EbsBlockDeviceConfigJsonMarshaller.getInstance().marshall(ebsBlockDeviceConfigsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (ebsConfiguration.getEbsOptimized() != null) {
                jsonGenerator.writeFieldName("EbsOptimized").writeValue(ebsConfiguration.getEbsOptimized().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EbsConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EbsConfigurationJsonMarshaller();
        }
        return instance;
    }
}

