/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.EbsVolume;
import com.amazonaws.services.elasticmapreduce.model.Instance;
import com.amazonaws.services.elasticmapreduce.model.transform.EbsVolumeJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceStatusJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class InstanceJsonMarshaller {
    private static InstanceJsonMarshaller instance;

    public void marshall(Instance instance, SdkJsonGenerator jsonGenerator) {
        if (instance == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList ebsVolumesList;
            jsonGenerator.writeStartObject();
            if (instance.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(instance.getId());
            }
            if (instance.getEc2InstanceId() != null) {
                jsonGenerator.writeFieldName("Ec2InstanceId").writeValue(instance.getEc2InstanceId());
            }
            if (instance.getPublicDnsName() != null) {
                jsonGenerator.writeFieldName("PublicDnsName").writeValue(instance.getPublicDnsName());
            }
            if (instance.getPublicIpAddress() != null) {
                jsonGenerator.writeFieldName("PublicIpAddress").writeValue(instance.getPublicIpAddress());
            }
            if (instance.getPrivateDnsName() != null) {
                jsonGenerator.writeFieldName("PrivateDnsName").writeValue(instance.getPrivateDnsName());
            }
            if (instance.getPrivateIpAddress() != null) {
                jsonGenerator.writeFieldName("PrivateIpAddress").writeValue(instance.getPrivateIpAddress());
            }
            if (instance.getStatus() != null) {
                jsonGenerator.writeFieldName("Status");
                InstanceStatusJsonMarshaller.getInstance().marshall(instance.getStatus(), jsonGenerator);
            }
            if (instance.getInstanceGroupId() != null) {
                jsonGenerator.writeFieldName("InstanceGroupId").writeValue(instance.getInstanceGroupId());
            }
            if (!(ebsVolumesList = (SdkInternalList)instance.getEbsVolumes()).isEmpty() || !ebsVolumesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EbsVolumes");
                jsonGenerator.writeStartArray();
                for (EbsVolume ebsVolumesListValue : ebsVolumesList) {
                    if (ebsVolumesListValue == null) continue;
                    EbsVolumeJsonMarshaller.getInstance().marshall(ebsVolumesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceJsonMarshaller();
        }
        return instance;
    }
}

