/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.Application;
import com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig;
import com.amazonaws.services.elasticmapreduce.model.Tag;
import com.amazonaws.services.elasticmapreduce.model.transform.ApplicationJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.BootstrapActionConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ConfigurationJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.JobFlowInstancesConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.SupportedProductConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RunJobFlowRequestMarshaller
implements Marshaller<Request<RunJobFlowRequest>, RunJobFlowRequest> {
    public Request<RunJobFlowRequest> marshall(RunJobFlowRequest runJobFlowRequest) {
        if (runJobFlowRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runJobFlowRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.RunJobFlow");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagsList;
            SdkInternalList configurationsList;
            SdkInternalList applicationsList;
            SdkInternalList newSupportedProductsList;
            SdkInternalList supportedProductsList;
            SdkInternalList bootstrapActionsList;
            SdkInternalList stepsList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (runJobFlowRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(runJobFlowRequest.getName());
            }
            if (runJobFlowRequest.getLogUri() != null) {
                jsonGenerator.writeFieldName("LogUri").writeValue(runJobFlowRequest.getLogUri());
            }
            if (runJobFlowRequest.getAdditionalInfo() != null) {
                jsonGenerator.writeFieldName("AdditionalInfo").writeValue(runJobFlowRequest.getAdditionalInfo());
            }
            if (runJobFlowRequest.getAmiVersion() != null) {
                jsonGenerator.writeFieldName("AmiVersion").writeValue(runJobFlowRequest.getAmiVersion());
            }
            if (runJobFlowRequest.getReleaseLabel() != null) {
                jsonGenerator.writeFieldName("ReleaseLabel").writeValue(runJobFlowRequest.getReleaseLabel());
            }
            if (runJobFlowRequest.getInstances() != null) {
                jsonGenerator.writeFieldName("Instances");
                JobFlowInstancesConfigJsonMarshaller.getInstance().marshall(runJobFlowRequest.getInstances(), jsonGenerator);
            }
            if (!(stepsList = (SdkInternalList)runJobFlowRequest.getSteps()).isEmpty() || !stepsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Steps");
                jsonGenerator.writeStartArray();
                for (Object stepsListValue : stepsList) {
                    if (stepsListValue == null) continue;
                    StepConfigJsonMarshaller.getInstance().marshall((StepConfig)stepsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(bootstrapActionsList = (SdkInternalList)runJobFlowRequest.getBootstrapActions()).isEmpty() || !bootstrapActionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("BootstrapActions");
                jsonGenerator.writeStartArray();
                for (Object bootstrapActionsListValue : bootstrapActionsList) {
                    if (bootstrapActionsListValue == null) continue;
                    BootstrapActionConfigJsonMarshaller.getInstance().marshall((BootstrapActionConfig)bootstrapActionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(supportedProductsList = (SdkInternalList)runJobFlowRequest.getSupportedProducts()).isEmpty() || !supportedProductsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SupportedProducts");
                jsonGenerator.writeStartArray();
                for (Object supportedProductsListValue : supportedProductsList) {
                    if (supportedProductsListValue == null) continue;
                    jsonGenerator.writeValue((String)supportedProductsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(newSupportedProductsList = (SdkInternalList)runJobFlowRequest.getNewSupportedProducts()).isEmpty() || !newSupportedProductsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("NewSupportedProducts");
                jsonGenerator.writeStartArray();
                for (Object newSupportedProductsListValue : newSupportedProductsList) {
                    if (newSupportedProductsListValue == null) continue;
                    SupportedProductConfigJsonMarshaller.getInstance().marshall((SupportedProductConfig)newSupportedProductsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(applicationsList = (SdkInternalList)runJobFlowRequest.getApplications()).isEmpty() || !applicationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Applications");
                jsonGenerator.writeStartArray();
                for (Object applicationsListValue : applicationsList) {
                    if (applicationsListValue == null) continue;
                    ApplicationJsonMarshaller.getInstance().marshall((Application)applicationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(configurationsList = (SdkInternalList)runJobFlowRequest.getConfigurations()).isEmpty() || !configurationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Configurations");
                jsonGenerator.writeStartArray();
                for (Object configurationsListValue : configurationsList) {
                    if (configurationsListValue == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall((Configuration)configurationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (runJobFlowRequest.getVisibleToAllUsers() != null) {
                jsonGenerator.writeFieldName("VisibleToAllUsers").writeValue(runJobFlowRequest.getVisibleToAllUsers().booleanValue());
            }
            if (runJobFlowRequest.getJobFlowRole() != null) {
                jsonGenerator.writeFieldName("JobFlowRole").writeValue(runJobFlowRequest.getJobFlowRole());
            }
            if (runJobFlowRequest.getServiceRole() != null) {
                jsonGenerator.writeFieldName("ServiceRole").writeValue(runJobFlowRequest.getServiceRole());
            }
            if (!(tagsList = (SdkInternalList)runJobFlowRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

