/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceGroupConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.PlacementTypeJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class JobFlowInstancesConfigJsonMarshaller {
    private static JobFlowInstancesConfigJsonMarshaller instance;

    public void marshall(JobFlowInstancesConfig jobFlowInstancesConfig, SdkJsonGenerator jsonGenerator) {
        if (jobFlowInstancesConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList additionalSlaveSecurityGroupsList;
            SdkInternalList additionalMasterSecurityGroupsList;
            SdkInternalList instanceGroupsList;
            jsonGenerator.writeStartObject();
            if (jobFlowInstancesConfig.getMasterInstanceType() != null) {
                jsonGenerator.writeFieldName("MasterInstanceType").writeValue(jobFlowInstancesConfig.getMasterInstanceType());
            }
            if (jobFlowInstancesConfig.getSlaveInstanceType() != null) {
                jsonGenerator.writeFieldName("SlaveInstanceType").writeValue(jobFlowInstancesConfig.getSlaveInstanceType());
            }
            if (jobFlowInstancesConfig.getInstanceCount() != null) {
                jsonGenerator.writeFieldName("InstanceCount").writeValue((long)jobFlowInstancesConfig.getInstanceCount().intValue());
            }
            if (!(instanceGroupsList = (SdkInternalList)jobFlowInstancesConfig.getInstanceGroups()).isEmpty() || !instanceGroupsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceGroups");
                jsonGenerator.writeStartArray();
                for (Object instanceGroupsListValue : instanceGroupsList) {
                    if (instanceGroupsListValue == null) continue;
                    InstanceGroupConfigJsonMarshaller.getInstance().marshall((InstanceGroupConfig)instanceGroupsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (jobFlowInstancesConfig.getEc2KeyName() != null) {
                jsonGenerator.writeFieldName("Ec2KeyName").writeValue(jobFlowInstancesConfig.getEc2KeyName());
            }
            if (jobFlowInstancesConfig.getPlacement() != null) {
                jsonGenerator.writeFieldName("Placement");
                PlacementTypeJsonMarshaller.getInstance().marshall(jobFlowInstancesConfig.getPlacement(), jsonGenerator);
            }
            if (jobFlowInstancesConfig.getKeepJobFlowAliveWhenNoSteps() != null) {
                jsonGenerator.writeFieldName("KeepJobFlowAliveWhenNoSteps").writeValue(jobFlowInstancesConfig.getKeepJobFlowAliveWhenNoSteps().booleanValue());
            }
            if (jobFlowInstancesConfig.getTerminationProtected() != null) {
                jsonGenerator.writeFieldName("TerminationProtected").writeValue(jobFlowInstancesConfig.getTerminationProtected().booleanValue());
            }
            if (jobFlowInstancesConfig.getHadoopVersion() != null) {
                jsonGenerator.writeFieldName("HadoopVersion").writeValue(jobFlowInstancesConfig.getHadoopVersion());
            }
            if (jobFlowInstancesConfig.getEc2SubnetId() != null) {
                jsonGenerator.writeFieldName("Ec2SubnetId").writeValue(jobFlowInstancesConfig.getEc2SubnetId());
            }
            if (jobFlowInstancesConfig.getEmrManagedMasterSecurityGroup() != null) {
                jsonGenerator.writeFieldName("EmrManagedMasterSecurityGroup").writeValue(jobFlowInstancesConfig.getEmrManagedMasterSecurityGroup());
            }
            if (jobFlowInstancesConfig.getEmrManagedSlaveSecurityGroup() != null) {
                jsonGenerator.writeFieldName("EmrManagedSlaveSecurityGroup").writeValue(jobFlowInstancesConfig.getEmrManagedSlaveSecurityGroup());
            }
            if (jobFlowInstancesConfig.getServiceAccessSecurityGroup() != null) {
                jsonGenerator.writeFieldName("ServiceAccessSecurityGroup").writeValue(jobFlowInstancesConfig.getServiceAccessSecurityGroup());
            }
            if (!(additionalMasterSecurityGroupsList = (SdkInternalList)jobFlowInstancesConfig.getAdditionalMasterSecurityGroups()).isEmpty() || !additionalMasterSecurityGroupsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("AdditionalMasterSecurityGroups");
                jsonGenerator.writeStartArray();
                for (String additionalMasterSecurityGroupsListValue : additionalMasterSecurityGroupsList) {
                    if (additionalMasterSecurityGroupsListValue == null) continue;
                    jsonGenerator.writeValue(additionalMasterSecurityGroupsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(additionalSlaveSecurityGroupsList = (SdkInternalList)jobFlowInstancesConfig.getAdditionalSlaveSecurityGroups()).isEmpty() || !additionalSlaveSecurityGroupsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("AdditionalSlaveSecurityGroups");
                jsonGenerator.writeStartArray();
                for (String additionalSlaveSecurityGroupsListValue : additionalSlaveSecurityGroupsList) {
                    if (additionalSlaveSecurityGroupsListValue == null) continue;
                    jsonGenerator.writeValue(additionalSlaveSecurityGroupsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobFlowInstancesConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobFlowInstancesConfigJsonMarshaller();
        }
        return instance;
    }
}

