/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListInstancesRequestMarshaller
implements Marshaller<Request<ListInstancesRequest>, ListInstancesRequest> {
    public Request<ListInstancesRequest> marshall(ListInstancesRequest listInstancesRequest) {
        if (listInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listInstancesRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.ListInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList instanceGroupTypesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (listInstancesRequest.getClusterId() != null) {
                jsonWriter.key("ClusterId").value((Object)listInstancesRequest.getClusterId());
            }
            if (listInstancesRequest.getInstanceGroupId() != null) {
                jsonWriter.key("InstanceGroupId").value((Object)listInstancesRequest.getInstanceGroupId());
            }
            if (!(instanceGroupTypesList = (SdkInternalList)listInstancesRequest.getInstanceGroupTypes()).isEmpty() || !instanceGroupTypesList.isAutoConstruct()) {
                jsonWriter.key("InstanceGroupTypes");
                jsonWriter.array();
                for (String instanceGroupTypesListValue : instanceGroupTypesList) {
                    if (instanceGroupTypesListValue == null) continue;
                    jsonWriter.value((Object)instanceGroupTypesListValue);
                }
                jsonWriter.endArray();
            }
            if (listInstancesRequest.getMarker() != null) {
                jsonWriter.key("Marker").value((Object)listInstancesRequest.getMarker());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

