/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig;
import com.amazonaws.services.elasticmapreduce.model.EbsConfiguration;
import com.amazonaws.services.elasticmapreduce.model.transform.EbsBlockDeviceConfigJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class EbsConfigurationJsonMarshaller {
    private static EbsConfigurationJsonMarshaller instance;

    public void marshall(EbsConfiguration ebsConfiguration, JSONWriter jsonWriter) {
        if (ebsConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            SdkInternalList ebsBlockDeviceConfigsList = (SdkInternalList)ebsConfiguration.getEbsBlockDeviceConfigs();
            if (!ebsBlockDeviceConfigsList.isEmpty() || !ebsBlockDeviceConfigsList.isAutoConstruct()) {
                jsonWriter.key("EbsBlockDeviceConfigs");
                jsonWriter.array();
                for (EbsBlockDeviceConfig ebsBlockDeviceConfigsListValue : ebsBlockDeviceConfigsList) {
                    if (ebsBlockDeviceConfigsListValue == null) continue;
                    EbsBlockDeviceConfigJsonMarshaller.getInstance().marshall(ebsBlockDeviceConfigsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (ebsConfiguration.getEbsOptimized() != null) {
                jsonWriter.key("EbsOptimized").value((Object)ebsConfiguration.getEbsOptimized());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EbsConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EbsConfigurationJsonMarshaller();
        }
        return instance;
    }
}

