/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.services.elasticmapreduce.model.KeyValue;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class AddJobFlowStepsRequestMarshaller
implements Marshaller<Request<AddJobFlowStepsRequest>, AddJobFlowStepsRequest> {
    public Request<AddJobFlowStepsRequest> marshall(AddJobFlowStepsRequest addJobFlowStepsRequest) {
        if (addJobFlowStepsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addJobFlowStepsRequest, "AmazonElasticMapReduce");
        String target = "ElasticMapReduce.AddJobFlowSteps";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag stepsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (addJobFlowStepsRequest.getJobFlowId() != null) {
                jsonWriter.key("JobFlowId").value((Object)addJobFlowStepsRequest.getJobFlowId());
            }
            if (!((stepsList = (ListWithAutoConstructFlag)addJobFlowStepsRequest.getSteps()) == null || stepsList.isAutoConstruct() && stepsList.isEmpty())) {
                jsonWriter.key("Steps");
                jsonWriter.array();
                for (StepConfig stepsListValue : stepsList) {
                    HadoopJarStepConfig hadoopJarStep;
                    if (stepsListValue == null) continue;
                    jsonWriter.object();
                    if (stepsListValue.getName() != null) {
                        jsonWriter.key("Name").value((Object)stepsListValue.getName());
                    }
                    if (stepsListValue.getActionOnFailure() != null) {
                        jsonWriter.key("ActionOnFailure").value((Object)stepsListValue.getActionOnFailure());
                    }
                    if ((hadoopJarStep = stepsListValue.getHadoopJarStep()) != null) {
                        ListWithAutoConstructFlag argsList;
                        jsonWriter.key("HadoopJarStep");
                        jsonWriter.object();
                        ListWithAutoConstructFlag propertiesList = (ListWithAutoConstructFlag)hadoopJarStep.getProperties();
                        if (!(propertiesList == null || propertiesList.isAutoConstruct() && propertiesList.isEmpty())) {
                            jsonWriter.key("Properties");
                            jsonWriter.array();
                            for (KeyValue propertiesListValue : propertiesList) {
                                if (propertiesListValue == null) continue;
                                jsonWriter.object();
                                if (propertiesListValue.getKey() != null) {
                                    jsonWriter.key("Key").value((Object)propertiesListValue.getKey());
                                }
                                if (propertiesListValue.getValue() != null) {
                                    jsonWriter.key("Value").value((Object)propertiesListValue.getValue());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endArray();
                        }
                        if (hadoopJarStep.getJar() != null) {
                            jsonWriter.key("Jar").value((Object)hadoopJarStep.getJar());
                        }
                        if (hadoopJarStep.getMainClass() != null) {
                            jsonWriter.key("MainClass").value((Object)hadoopJarStep.getMainClass());
                        }
                        if (!((argsList = (ListWithAutoConstructFlag)hadoopJarStep.getArgs()) == null || argsList.isAutoConstruct() && argsList.isEmpty())) {
                            jsonWriter.key("Args");
                            jsonWriter.array();
                            for (String argsListValue : argsList) {
                                if (argsListValue == null) continue;
                                jsonWriter.value((Object)argsListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

