/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.Preset;
import com.amazonaws.services.elastictranscoder.model.transform.AudioParametersJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ThumbnailsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.VideoParametersJsonMarshaller;

public class PresetJsonMarshaller {
    private static PresetJsonMarshaller instance;

    public void marshall(Preset preset, StructuredJsonGenerator jsonGenerator) {
        if (preset == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (preset.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(preset.getId());
            }
            if (preset.getArn() != null) {
                jsonGenerator.writeFieldName("Arn").writeValue(preset.getArn());
            }
            if (preset.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(preset.getName());
            }
            if (preset.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(preset.getDescription());
            }
            if (preset.getContainer() != null) {
                jsonGenerator.writeFieldName("Container").writeValue(preset.getContainer());
            }
            if (preset.getAudio() != null) {
                jsonGenerator.writeFieldName("Audio");
                AudioParametersJsonMarshaller.getInstance().marshall(preset.getAudio(), jsonGenerator);
            }
            if (preset.getVideo() != null) {
                jsonGenerator.writeFieldName("Video");
                VideoParametersJsonMarshaller.getInstance().marshall(preset.getVideo(), jsonGenerator);
            }
            if (preset.getThumbnails() != null) {
                jsonGenerator.writeFieldName("Thumbnails");
                ThumbnailsJsonMarshaller.getInstance().marshall(preset.getThumbnails(), jsonGenerator);
            }
            if (preset.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(preset.getType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PresetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PresetJsonMarshaller();
        }
        return instance;
    }
}

