/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticsearch.model.transform.CompatibleVersionsMapMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CompatibleVersionsMap
implements Serializable,
Cloneable,
StructuredPojo {
    private String sourceVersion;
    private List<String> targetVersions;

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public CompatibleVersionsMap withSourceVersion(String sourceVersion) {
        this.setSourceVersion(sourceVersion);
        return this;
    }

    public List<String> getTargetVersions() {
        return this.targetVersions;
    }

    public void setTargetVersions(Collection<String> targetVersions) {
        if (targetVersions == null) {
            this.targetVersions = null;
            return;
        }
        this.targetVersions = new ArrayList<String>(targetVersions);
    }

    public CompatibleVersionsMap withTargetVersions(String ... targetVersions) {
        if (this.targetVersions == null) {
            this.setTargetVersions(new ArrayList<String>(targetVersions.length));
        }
        for (String ele : targetVersions) {
            this.targetVersions.add(ele);
        }
        return this;
    }

    public CompatibleVersionsMap withTargetVersions(Collection<String> targetVersions) {
        this.setTargetVersions(targetVersions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceVersion() != null) {
            sb.append("SourceVersion: ").append(this.getSourceVersion()).append(",");
        }
        if (this.getTargetVersions() != null) {
            sb.append("TargetVersions: ").append(this.getTargetVersions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompatibleVersionsMap)) {
            return false;
        }
        CompatibleVersionsMap other = (CompatibleVersionsMap)obj;
        if (other.getSourceVersion() == null ^ this.getSourceVersion() == null) {
            return false;
        }
        if (other.getSourceVersion() != null && !other.getSourceVersion().equals(this.getSourceVersion())) {
            return false;
        }
        if (other.getTargetVersions() == null ^ this.getTargetVersions() == null) {
            return false;
        }
        return other.getTargetVersions() == null || other.getTargetVersions().equals(this.getTargetVersions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceVersion() == null ? 0 : this.getSourceVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTargetVersions() == null ? 0 : this.getTargetVersions().hashCode());
        return hashCode;
    }

    public CompatibleVersionsMap clone() {
        try {
            return (CompatibleVersionsMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CompatibleVersionsMapMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

