/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticsearch.model.transform.PackageSourceMarshaller;
import java.io.Serializable;

public class PackageSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3BucketName;
    private String s3Key;

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public PackageSource withS3BucketName(String s3BucketName) {
        this.setS3BucketName(s3BucketName);
        return this;
    }

    public void setS3Key(String s3Key) {
        this.s3Key = s3Key;
    }

    public String getS3Key() {
        return this.s3Key;
    }

    public PackageSource withS3Key(String s3Key) {
        this.setS3Key(s3Key);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3BucketName() != null) {
            sb.append("S3BucketName: ").append(this.getS3BucketName()).append(",");
        }
        if (this.getS3Key() != null) {
            sb.append("S3Key: ").append(this.getS3Key());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageSource)) {
            return false;
        }
        PackageSource other = (PackageSource)obj;
        if (other.getS3BucketName() == null ^ this.getS3BucketName() == null) {
            return false;
        }
        if (other.getS3BucketName() != null && !other.getS3BucketName().equals(this.getS3BucketName())) {
            return false;
        }
        if (other.getS3Key() == null ^ this.getS3Key() == null) {
            return false;
        }
        return other.getS3Key() == null || other.getS3Key().equals(this.getS3Key());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3BucketName() == null ? 0 : this.getS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.getS3Key() == null ? 0 : this.getS3Key().hashCode());
        return hashCode;
    }

    public PackageSource clone() {
        try {
            return (PackageSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PackageSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

