/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticsearch.model.AddTagsRequest;
import com.amazonaws.services.elasticsearch.model.Tag;
import com.amazonaws.services.elasticsearch.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class AddTagsRequestMarshaller
implements Marshaller<Request<AddTagsRequest>, AddTagsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<AddTagsRequest> marshall(AddTagsRequest addTagsRequest) {
        if (addTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addTagsRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-01-01/tags";
        request.setResourcePath(uriResourcePath);
        try {
            List<Tag> tagListList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (addTagsRequest.getARN() != null) {
                jsonGenerator.writeFieldName("ARN").writeValue(addTagsRequest.getARN());
            }
            if ((tagListList = addTagsRequest.getTagList()) != null) {
                jsonGenerator.writeFieldName("TagList");
                jsonGenerator.writeStartArray();
                for (Tag tagListListValue : tagListList) {
                    if (tagListListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

