/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticsearch.model.ElasticsearchDomainStatus;
import com.amazonaws.services.elasticsearch.model.transform.EBSOptionsJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.ElasticsearchClusterConfigJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.SnapshotOptionsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class ElasticsearchDomainStatusJsonMarshaller {
    private static ElasticsearchDomainStatusJsonMarshaller instance;

    public void marshall(ElasticsearchDomainStatus elasticsearchDomainStatus, JSONWriter jsonWriter) {
        if (elasticsearchDomainStatus == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> advancedOptionsMap;
            jsonWriter.object();
            if (elasticsearchDomainStatus.getDomainId() != null) {
                jsonWriter.key("DomainId").value((Object)elasticsearchDomainStatus.getDomainId());
            }
            if (elasticsearchDomainStatus.getDomainName() != null) {
                jsonWriter.key("DomainName").value((Object)elasticsearchDomainStatus.getDomainName());
            }
            if (elasticsearchDomainStatus.getARN() != null) {
                jsonWriter.key("ARN").value((Object)elasticsearchDomainStatus.getARN());
            }
            if (elasticsearchDomainStatus.getCreated() != null) {
                jsonWriter.key("Created").value((Object)elasticsearchDomainStatus.getCreated());
            }
            if (elasticsearchDomainStatus.getDeleted() != null) {
                jsonWriter.key("Deleted").value((Object)elasticsearchDomainStatus.getDeleted());
            }
            if (elasticsearchDomainStatus.getEndpoint() != null) {
                jsonWriter.key("Endpoint").value((Object)elasticsearchDomainStatus.getEndpoint());
            }
            if (elasticsearchDomainStatus.getProcessing() != null) {
                jsonWriter.key("Processing").value((Object)elasticsearchDomainStatus.getProcessing());
            }
            if (elasticsearchDomainStatus.getElasticsearchClusterConfig() != null) {
                jsonWriter.key("ElasticsearchClusterConfig");
                ElasticsearchClusterConfigJsonMarshaller.getInstance().marshall(elasticsearchDomainStatus.getElasticsearchClusterConfig(), jsonWriter);
            }
            if (elasticsearchDomainStatus.getEBSOptions() != null) {
                jsonWriter.key("EBSOptions");
                EBSOptionsJsonMarshaller.getInstance().marshall(elasticsearchDomainStatus.getEBSOptions(), jsonWriter);
            }
            if (elasticsearchDomainStatus.getAccessPolicies() != null) {
                jsonWriter.key("AccessPolicies").value((Object)elasticsearchDomainStatus.getAccessPolicies());
            }
            if (elasticsearchDomainStatus.getSnapshotOptions() != null) {
                jsonWriter.key("SnapshotOptions");
                SnapshotOptionsJsonMarshaller.getInstance().marshall(elasticsearchDomainStatus.getSnapshotOptions(), jsonWriter);
            }
            if ((advancedOptionsMap = elasticsearchDomainStatus.getAdvancedOptions()) != null) {
                jsonWriter.key("AdvancedOptions");
                jsonWriter.object();
                for (Map.Entry<String, String> advancedOptionsMapValue : advancedOptionsMap.entrySet()) {
                    if (advancedOptionsMapValue.getValue() == null) continue;
                    jsonWriter.key(advancedOptionsMapValue.getKey());
                    jsonWriter.value((Object)advancedOptionsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ElasticsearchDomainStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ElasticsearchDomainStatusJsonMarshaller();
        }
        return instance;
    }
}

